/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections;

import com.floragunn.fluent.collections.AbstractImmutableCollection;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.fluent.collections.UnmodifiableIterator;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

class ImmutableListImpl {
    ImmutableListImpl() {
    }

    static <E> ImmutableList<E> empty() {
        EmptyList<?> result = EmptyList.INSTANCE;
        return result;
    }

    static <E> ImmutableList<E> of(E e) {
        return new OneElementList<E>(e);
    }

    static <E> ImmutableList<E> of(E e1, E e2) {
        return new TwoElementList<E>(e1, e2);
    }

    @SafeVarargs
    static <E> ImmutableList<E> of(E e1, E e2, E e3, E ... more) {
        int moreLength = more != null ? more.length : 0;
        Object[] joinedArray = new Object[moreLength + 3];
        joinedArray[0] = e1;
        joinedArray[1] = e2;
        joinedArray[2] = e3;
        if (moreLength > 0) {
            System.arraycopy(more, 0, joinedArray, 3, more.length);
        }
        return new ArrayBackedList<Object>(joinedArray);
    }

    @SafeVarargs
    static <E> ImmutableList<E> ofArray(E ... more) {
        if (more == null || more.length == 0) {
            return ImmutableListImpl.empty();
        }
        if (more.length == 1) {
            return new OneElementList<E>(more[0]);
        }
        if (more.length == 2) {
            return new TwoElementList<E>(more[0], more[1]);
        }
        return new ArrayBackedList<E>(more);
    }

    static <E> ImmutableList<E> of(Collection<? extends E> collection) {
        if (collection == null || collection.size() == 0) {
            return ImmutableListImpl.empty();
        }
        if (collection instanceof ImmutableList) {
            ImmutableList result = (ImmutableList)collection;
            return result;
        }
        if (collection.size() == 1) {
            return new OneElementList<E>(collection.iterator().next());
        }
        if (collection.size() == 2) {
            Iterator<E> iter = collection.iterator();
            E e1 = iter.next();
            E e2 = iter.next();
            return new TwoElementList<E>(e1, e2);
        }
        return new ArrayBackedList<E>(collection);
    }

    static <E> ImmutableList<E> ofNonNull(E e) {
        if (e != null) {
            return new OneElementList<E>(e);
        }
        return ImmutableListImpl.empty();
    }

    static <E> ImmutableList<E> ofNonNull(E e1, E e2) {
        if (e1 != null) {
            if (e2 != null) {
                return ImmutableListImpl.of(e1, e2);
            }
            return ImmutableListImpl.of(e1);
        }
        if (e2 != null) {
            return ImmutableListImpl.of(e2);
        }
        return ImmutableListImpl.empty();
    }

    @SafeVarargs
    static <E> ImmutableList<E> ofNonNull(E e1, E e2, E ... more) {
        if (more == null || more.length == 0) {
            return ImmutableListImpl.ofNonNull(e1, e2);
        }
        ImmutableList.Builder<E> builder = new ImmutableList.Builder<E>(more.length + 2);
        if (e1 != null) {
            builder.with(e1);
        }
        if (e2 != null) {
            builder.with(e2);
        }
        for (E e : more) {
            if (e == null) continue;
            builder.with(e);
        }
        return builder.build();
    }

    static <E> ImmutableList<E> concat(Collection<? extends E> c1, Collection<? extends E> c2) {
        if (c1 == null || c1.size() == 0) {
            return ImmutableListImpl.of(c2);
        }
        if (c2 == null || c2.size() == 0) {
            return ImmutableListImpl.of(c1);
        }
        Object[] array = new Object[c1.size() + c2.size()];
        int i = 0;
        for (E e : c1) {
            array[i] = e;
            ++i;
        }
        for (E e : c2) {
            array[i] = e;
            ++i;
        }
        return new ArrayBackedList<Object>(array);
    }

    static <E> ImmutableList<E> concat(Collection<? extends E> c1, Collection<? extends E> c2, Collection<? extends E> c3) {
        if (c1 == null || c1.size() == 0) {
            return ImmutableListImpl.concat(c2, c3);
        }
        if (c2 == null || c2.size() == 0) {
            return ImmutableListImpl.concat(c1, c3);
        }
        if (c3 == null || c3.size() == 0) {
            return ImmutableListImpl.concat(c1, c2);
        }
        Object[] array = new Object[c1.size() + c2.size() + c3.size()];
        int i = 0;
        for (E e : c1) {
            array[i] = e;
            ++i;
        }
        for (E e : c2) {
            array[i] = e;
            ++i;
        }
        for (E e : c3) {
            array[i] = e;
            ++i;
        }
        return new ArrayBackedList<Object>(array);
    }

    static <C, E> ImmutableList<E> map(Collection<C> collection, Function<C, E> mappingFunction) {
        ImmutableList.Builder<E> builder = new ImmutableList.Builder<E>(collection.size());
        for (C c : collection) {
            E value = mappingFunction.apply(c);
            if (value == null) continue;
            builder.with(value);
        }
        return builder.build();
    }

    static <E> Collector<E, ?, ImmutableList<E>> collector() {
        return new Collector<E, ImmutableList.Builder<E>, ImmutableList<E>>(){

            @Override
            public Supplier<ImmutableList.Builder<E>> supplier() {
                return ImmutableList.Builder::new;
            }

            @Override
            public BiConsumer<ImmutableList.Builder<E>, E> accumulator() {
                return ImmutableList.Builder::add;
            }

            @Override
            public BinaryOperator<ImmutableList.Builder<E>> combiner() {
                return (builder1, builder2) -> {
                    builder1.addAll(builder2.build());
                    return builder1;
                };
            }

            @Override
            public Function<ImmutableList.Builder<E>, ImmutableList<E>> finisher() {
                return ImmutableList.Builder::build;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return ImmutableSet.empty();
            }
        };
    }

    static class EmptyList<E>
    extends AbstractImmutableList<E> {
        static EmptyList<?> INSTANCE = new EmptyList();

        EmptyList() {
        }

        @Override
        public E any() {
            throw new IllegalStateException();
        }

        @Override
        public E only() {
            throw new IllegalStateException();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return UnmodifiableIterator.empty();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return a;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public ImmutableList<E> matching(Predicate<E> predicate) {
            return this;
        }

        @Override
        public String toString() {
            return "[]";
        }

        @Override
        public String toShortString() {
            return "[]";
        }

        @Override
        public E get(int index) {
            throw new IndexOutOfBoundsException("index: " + index);
        }

        @Override
        public int indexOf(Object o) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return -1;
        }

        @Override
        public ImmutableList<E> subList(int fromIndex, int toIndex) {
            if (fromIndex == 0 && toIndex == 0) {
                return this;
            }
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + "; toIndex: " + toIndex);
        }

        @Override
        public <O> ImmutableList<O> map(Function<E, O> mappingFunction) {
            return ImmutableListImpl.empty();
        }

        @Override
        public boolean forAllApplies(Predicate<E> predicate) {
            return true;
        }

        @Override
        public boolean forAnyApplies(Predicate<E> predicate) {
            return false;
        }

        @Override
        public E first() {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public E last() {
            throw new IndexOutOfBoundsException();
        }
    }

    static class ArrayBackedList<E>
    extends AbstractImmutableList<E> {
        private final E[] elements;
        private String cachedToShortString;

        ArrayBackedList(E[] elements) {
            this.elements = elements;
        }

        ArrayBackedList(Collection<? extends E> elements) {
            this.elements = elements.toArray();
        }

        @Override
        public int size() {
            return this.elements.length;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (!this.elements[i].equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return UnmodifiableIterator.of(this.elements);
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.elements.length];
            System.arraycopy(this.elements, 0, result, 0, this.elements.length);
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] result = a.length >= this.elements.length ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), this.elements.length);
            System.arraycopy(this.elements, 0, result, 0, this.elements.length);
            return result;
        }

        @Override
        public E any() {
            return this.elements[0];
        }

        @Override
        public E only() {
            if (this.size() != 1) {
                throw new IllegalStateException();
            }
            return this.elements[0];
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c.size() == 0) {
                return true;
            }
            if (c instanceof Set && c.size() > this.elements.length) {
                return false;
            }
            for (Object other : c) {
                if (this.contains(other)) continue;
                return false;
            }
            return true;
        }

        @Override
        public ImmutableList<E> matching(Predicate<E> predicate) {
            Object[] newElements = new Object[this.elements.length];
            int k = 0;
            for (int i = 0; i < this.elements.length; ++i) {
                E e = this.elements[i];
                if (!predicate.test(e)) continue;
                newElements[k] = e;
                ++k;
            }
            if (k == 0) {
                return ImmutableListImpl.empty();
            }
            if (k == 1) {
                return new OneElementList<Object>(newElements[0]);
            }
            if (k == 2) {
                return new TwoElementList<Object>(newElements[0], newElements[1]);
            }
            if (k < this.elements.length) {
                Object[] newElements2 = new Object[k];
                System.arraycopy(newElements, 0, newElements2, 0, k);
                return new ArrayBackedList<Object>(newElements2);
            }
            return this;
        }

        @Override
        public String toShortString() {
            if (this.cachedToShortString == null) {
                StringBuilder result = new StringBuilder("[");
                for (int i = 0; i < this.elements.length; ++i) {
                    if (i != 0) {
                        result.append(", ");
                    }
                    result.append(this.elements[i]);
                }
                result.append("]");
                this.cachedToShortString = result.toString();
            }
            return this.cachedToShortString;
        }

        @Override
        public E get(int index) {
            return this.elements[index];
        }

        @Override
        public int indexOf(Object o) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (!this.elements[i].equals(o)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            for (int i = this.elements.length - 1; i >= 0; --i) {
                if (!this.elements[i].equals(o)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public ImmutableList<E> subList(int fromIndex, int toIndex) {
            this.validateSubListRange(fromIndex, toIndex);
            if (fromIndex == toIndex) {
                return ImmutableListImpl.empty();
            }
            Object[] newElements = new Object[toIndex - fromIndex];
            System.arraycopy(this.elements, fromIndex, newElements, 0, newElements.length);
            return new ArrayBackedList<Object>(newElements);
        }

        @Override
        public <O> ImmutableList<O> map(Function<E, O> mappingFunction) {
            Object[] newArray = new Object[this.elements.length];
            int k = 0;
            for (int i = 0; i < this.elements.length; ++i) {
                O newValue = mappingFunction.apply(this.elements[i]);
                if (newValue == null) continue;
                newArray[k] = newValue;
                ++k;
            }
            if (k == 0) {
                return ImmutableListImpl.empty();
            }
            if (k == this.elements.length) {
                return new ArrayBackedList<Object>(newArray);
            }
            Object[] subArray = new Object[k];
            System.arraycopy(newArray, 0, subArray, 0, k);
            return new ArrayBackedList<Object>(subArray);
        }

        @Override
        public boolean forAllApplies(Predicate<E> predicate) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (predicate.test(this.elements[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean forAnyApplies(Predicate<E> predicate) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (!predicate.test(this.elements[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public E first() {
            return this.elements[0];
        }

        @Override
        public E last() {
            return this.elements[this.elements.length - 1];
        }
    }

    static class TwoElementList<E>
    extends AbstractImmutableList<E> {
        private final E e1;
        private final E e2;

        TwoElementList(E e1, E e2) {
            this.e1 = e1;
            this.e2 = e2;
        }

        @Override
        public E any() {
            return this.e1;
        }

        @Override
        public E only() {
            throw new IllegalStateException();
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return this.e1.equals(o) || this.e2.equals(o);
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return new UnmodifiableIterator<E>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < 2;
                }

                @Override
                public E next() {
                    if (this.i == 0) {
                        ++this.i;
                        return e1;
                    }
                    if (this.i == 1) {
                        ++this.i;
                        return e2;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.e1, this.e2};
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] result = a.length >= 2 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 2);
            result[0] = this.e1;
            result[1] = this.e2;
            return result;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c.size() == 0) {
                return true;
            }
            if (c instanceof Set && c.size() > 2) {
                return false;
            }
            for (Object other : c) {
                if (this.e1 == other || this.e2 == other) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return (31 + this.e1.hashCode()) * 31 + this.e2.hashCode();
        }

        @Override
        public ImmutableList<E> matching(Predicate<E> predicate) {
            if (predicate.test(this.e1)) {
                if (predicate.test(this.e2)) {
                    return this;
                }
                return new OneElementList<E>(this.e1);
            }
            if (predicate.test(this.e2)) {
                return new OneElementList<E>(this.e2);
            }
            return ImmutableListImpl.empty();
        }

        @Override
        public String toString() {
            if (this.cachedToString == null) {
                this.cachedToString = "[" + this.e1 + ", " + this.e2 + "]";
            }
            return this.cachedToString;
        }

        @Override
        public String toShortString() {
            return this.toString();
        }

        @Override
        public E get(int index) {
            if (index == 0) {
                return this.e1;
            }
            if (index == 1) {
                return this.e2;
            }
            throw new IndexOutOfBoundsException("index out of bounds: " + index);
        }

        @Override
        public int indexOf(Object o) {
            if (this.e1.equals(o)) {
                return 0;
            }
            if (this.e2.equals(o)) {
                return 1;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (this.e2.equals(o)) {
                return 1;
            }
            if (this.e1.equals(o)) {
                return 0;
            }
            return -1;
        }

        @Override
        public ImmutableList<E> subList(int fromIndex, int toIndex) {
            if (fromIndex == toIndex && (fromIndex == 0 || fromIndex == 1 || fromIndex == 2)) {
                return ImmutableListImpl.empty();
            }
            if (fromIndex == 0 && toIndex == 1) {
                return new OneElementList<E>(this.e1);
            }
            if (fromIndex == 1 && toIndex == 2) {
                return new OneElementList<E>(this.e2);
            }
            if (fromIndex == 0 && toIndex == 2) {
                return this;
            }
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + "; toIndex: " + toIndex);
        }

        @Override
        public <O> ImmutableList<O> map(Function<E, O> mappingFunction) {
            O o1 = mappingFunction.apply(this.e1);
            O o2 = mappingFunction.apply(this.e2);
            if (o1 != null) {
                if (o2 != null) {
                    return new TwoElementList<O>(o1, o2);
                }
                return new OneElementList<O>(o1);
            }
            if (o2 != null) {
                return new OneElementList<O>(o2);
            }
            return ImmutableListImpl.empty();
        }

        @Override
        public boolean forAllApplies(Predicate<E> predicate) {
            return predicate.test(this.e1) && predicate.test(this.e2);
        }

        @Override
        public boolean forAnyApplies(Predicate<E> predicate) {
            return predicate.test(this.e1) || predicate.test(this.e2);
        }

        @Override
        public E first() {
            return this.e1;
        }

        @Override
        public E last() {
            return this.e2;
        }
    }

    static class OneElementList<E>
    extends AbstractImmutableList<E> {
        private final E e1;

        OneElementList(E e1) {
            this.e1 = e1;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return this.e1.equals(o);
        }

        @Override
        public E any() {
            return this.e1;
        }

        @Override
        public E only() {
            return this.e1;
        }

        @Override
        public UnmodifiableIterator<E> iterator() {
            return UnmodifiableIterator.of(this.e1);
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.e1};
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c.size() == 0) {
                return true;
            }
            if (c instanceof Set && c.size() > 1) {
                return false;
            }
            for (Object other : c) {
                if (this.e1 == other) continue;
                return false;
            }
            return true;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] result = a.length >= 1 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
            result[0] = this.e1;
            return result;
        }

        @Override
        public int hashCode() {
            return 31 + this.e1.hashCode();
        }

        @Override
        public ImmutableList<E> matching(Predicate<E> predicate) {
            if (predicate.test(this.e1)) {
                return this;
            }
            return ImmutableListImpl.empty();
        }

        @Override
        public String toString() {
            if (this.cachedToString == null) {
                this.cachedToString = "[" + this.e1 + "]";
            }
            return this.cachedToString;
        }

        @Override
        public String toShortString() {
            return this.toString();
        }

        @Override
        public E get(int index) {
            if (index == 0) {
                return this.e1;
            }
            throw new IndexOutOfBoundsException("index out of bounds: " + index);
        }

        @Override
        public int indexOf(Object o) {
            if (this.e1.equals(o)) {
                return 0;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.indexOf(o);
        }

        @Override
        public ImmutableList<E> subList(int fromIndex, int toIndex) {
            if (fromIndex == toIndex && (fromIndex == 0 || fromIndex == 1)) {
                return ImmutableListImpl.empty();
            }
            if (fromIndex == 0 && toIndex == 1) {
                return this;
            }
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + "; toIndex: " + toIndex);
        }

        @Override
        public <O> ImmutableList<O> map(Function<E, O> mappingFunction) {
            O o1 = mappingFunction.apply(this.e1);
            if (o1 != null) {
                return new OneElementList<O>(o1);
            }
            return ImmutableListImpl.empty();
        }

        @Override
        public ImmutableList<E> with(Optional<E> other) {
            if (other.isPresent()) {
                return new TwoElementList<E>(this.e1, other.get());
            }
            return this;
        }

        @Override
        public boolean forAllApplies(Predicate<E> predicate) {
            return predicate.test(this.e1);
        }

        @Override
        public boolean forAnyApplies(Predicate<E> predicate) {
            return predicate.test(this.e1);
        }

        @Override
        public E first() {
            return this.e1;
        }

        @Override
        public E last() {
            return this.e1;
        }
    }

    static abstract class AbstractImmutableList<E>
    extends AbstractImmutableCollection<E>
    implements ImmutableList<E> {
        private int hashCode = -1;

        AbstractImmutableList() {
        }

        @Override
        public ImmutableList<E> with(E other) {
            int size = this.size();
            if (size == 0) {
                return new OneElementList<E>(other);
            }
            if (size == 1) {
                return new TwoElementList(this.only(), other);
            }
            return new ImmutableList.Builder<E>(this).with(other).build();
        }

        @Override
        public ImmutableList<E> with(Collection<E> other) {
            int size = this.size();
            int otherSize = other.size();
            if (size == 0) {
                return ImmutableList.of(other);
            }
            if (otherSize == 0) {
                return this;
            }
            if (other.size() == 1) {
                return this.with(other.iterator().next());
            }
            return new ImmutableList.Builder<E>(this).with(other).build();
        }

        @Override
        public ImmutableList<E> with(Optional<E> other) {
            if (other.isPresent()) {
                return this.with(other.get());
            }
            return this;
        }

        @Override
        public ImmutableList<E> with(E ... other) {
            if (other == null || other.length == 0) {
                return this;
            }
            int size = this.size();
            int otherSize = other.length;
            if (size == 0) {
                return ImmutableList.ofArray(other);
            }
            if (otherSize == 1) {
                return this.with(other[0]);
            }
            return new ImmutableList.Builder<E>(this).with(Arrays.asList(other)).build();
        }

        @Override
        public ImmutableList<E> without(Collection<E> other) {
            return this.matching(e -> !other.contains(e));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof List) {
                List otherList = (List)o;
                if (otherList.size() != this.size()) {
                    return false;
                }
                Iterator iter1 = this.iterator();
                Iterator iter2 = otherList.iterator();
                while (iter1.hasNext()) {
                    if (iter1.next().equals(iter2.next())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            if (this.hashCode == -1) {
                int newHashCode = 1;
                for (Object e : this) {
                    newHashCode = 31 * newHashCode + e.hashCode();
                }
                this.hashCode = newHashCode;
            }
            return this.hashCode;
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            return new ListIterator<E>(){
                int i;
                {
                    this.i = index - 1;
                }

                @Override
                public boolean hasNext() {
                    return this.size() > this.i + 1;
                }

                @Override
                public E next() {
                    ++this.i;
                    return this.get(this.i);
                }

                @Override
                public boolean hasPrevious() {
                    return this.i > 0;
                }

                @Override
                public E previous() {
                    --this.i;
                    return this.get(this.i);
                }

                @Override
                public int nextIndex() {
                    return this.i + 1;
                }

                @Override
                public int previousIndex() {
                    return this.i - 1;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E e) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        protected void validateSubListRange(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + "; toIndex: " + toIndex);
            }
        }
    }
}

