/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.commands;

import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.encryption.at.rest.client.EnRestClient;
import com.floragunn.encryption.at.rest.client.FailedConnectionException;
import com.floragunn.encryption.at.rest.commands.BaseCommand;
import com.floragunn.encryption.at.rest.enctl.EnctlConfig;
import com.floragunn.encryption.at.rest.enctl.EnctlException;
import java.io.File;
import java.net.SocketException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpHost;
import picocli.CommandLine;

public abstract class ConnectingCommand
extends BaseCommand {
    @CommandLine.Option(names={"-u", "--user"}, description={"Username for authentication"})
    String user;
    @CommandLine.Option(names={"--password"}, description={"Password for authentication"})
    String password;
    @CommandLine.Option(names={"-h", "--host"}, description={"Hostname of the node to connect to"})
    String host;
    @CommandLine.Option(names={"-E", "--cert"}, description={"Client certificate for admin authentication"})
    File clientCert;
    @CommandLine.Option(names={"--force-https"}, arity="0..1", description={"Force https protocol"})
    Boolean forceHttps;
    @CommandLine.Option(names={"-p", "--port"}, description={"REST port to connect to. Default: 9200"})
    Integer serverPort;
    @CommandLine.Option(names={"--key"}, description={"Private key for admin authentication"})
    File clientKey;
    @CommandLine.Option(names={"--key-pass"}, description={"Password for private key"}, arity="0..1", interactive=true)
    String clientKeyPass;
    @CommandLine.Option(names={"--ca-cert"}, description={"Trusted certificates"})
    File caCert;
    @CommandLine.Option(names={"-k", "--insecure"}, arity="0..1", description={"Trust all certificates and do not verify the hostname when connecting to the cluster"})
    Boolean insecure;
    @CommandLine.Option(names={"--allow-http"}, arity="0..1", description={"Allow unencrypted http connection - this transmits passwords and encryptions in plain text"})
    Boolean allowHttp;

    private static boolean evaluateNotBoolean(Boolean bool) {
        if (bool != null) {
            return bool == false;
        }
        return true;
    }

    private static boolean evaluateBoolean(Boolean bool) {
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public EnRestClient getClient() throws EnctlException {
        try {
            EnRestClient client;
            EnctlConfig.Cluster clusterConfig = this.getSelectedClusterConfig();
            String server = this.getHost();
            Integer serverPort = this.serverPort;
            if (clusterConfig != null && server == null) {
                server = clusterConfig.getServer();
            }
            if (clusterConfig != null && serverPort == null) {
                serverPort = clusterConfig.getPort();
            }
            if (server == null) {
                throw new EnctlException("You must specify the server on the command line");
            }
            if (serverPort == null) {
                serverPort = 9200;
            }
            if (this.verbose) {
                System.out.println("Connecting to " + server + ":" + serverPort);
            }
            if (ConnectingCommand.evaluateBoolean(this.forceHttps)) {
                TLSConfig tlsConfig = new TLSConfig.Builder().trust(this.caCert).trustAll(ConnectingCommand.evaluateBoolean(this.insecure)).verifyHostnames(ConnectingCommand.evaluateNotBoolean(this.insecure)).build();
                client = new EnRestClient(new HttpHost(server, serverPort.intValue(), "https"), this.user, this.password, tlsConfig);
            } else {
                TLSConfig tlsConfig = this.getTlsConfig(clusterConfig);
                client = new EnRestClient(new HttpHost(server, serverPort.intValue(), tlsConfig == null ? "http" : "https"), this.user, this.password, tlsConfig);
            }
            client.debug(this.debug);
            return client;
        }
        catch (ConfigValidationException e) {
            throw new EnctlException("Connection settings are invalid:\n" + String.valueOf(e.getValidationErrors()), e).debugDetail(e.toDebugString());
        }
    }

    protected TLSConfig getTlsConfig(EnctlConfig.Cluster clusterConfig) throws ConfigValidationException {
        if (clusterConfig != null && this.clientCert == null && this.clientKey == null && this.clientKeyPass == null && this.caCert == null && this.insecure == null && this.allowHttp == null && this.forceHttps == null) {
            return clusterConfig.getTlsConfig();
        }
        if (clusterConfig == null) {
            if (!ConnectingCommand.evaluateBoolean(this.allowHttp)) {
                if (this.clientCert == null) {
                    this.validationErrors.add((ValidationError)new MissingAttribute("--cert"));
                }
                if (this.clientKey == null) {
                    this.validationErrors.add((ValidationError)new MissingAttribute("--key"));
                }
            }
            this.validationErrors.throwExceptionForPresentErrors();
            if (this.clientCert != null) {
                try {
                    return new TLSConfig.Builder().clientCert(this.clientCert, this.clientKey, this.clientKeyPass).trust(this.caCert).trustAll(ConnectingCommand.evaluateBoolean(this.insecure)).verifyHostnames(ConnectingCommand.evaluateNotBoolean(this.insecure)).build();
                }
                catch (ConfigValidationException e) {
                    this.validationErrors.add(null, e);
                }
            }
            this.validationErrors.throwExceptionForPresentErrors();
        } else if (clusterConfig != null) {
            Optional<TLSConfig> optionalTLSConfig = Optional.ofNullable(clusterConfig.getTlsConfig());
            Map config = optionalTLSConfig.map(TLSConfig::toBasicObject).orElse(new LinkedHashMap());
            Map clientAuthConfig = optionalTLSConfig.map(TLSConfig::getClientCertAuthConfig).map(TLSConfig.ClientCertAuthConfig::toBasicObject).orElse(new LinkedHashMap());
            HashMap<String, String> attributeMapping = new HashMap<String, String>();
            if (this.clientCert != null) {
                clientAuthConfig.put("certificate", "#{file:" + this.clientCert.getAbsolutePath() + "}");
                attributeMapping.put("certificate", "--cert");
            } else if (clientAuthConfig.get("certificate") == null) {
                attributeMapping.put("certificate", "--cert");
            }
            if (this.clientKey != null) {
                clientAuthConfig.put("private_key", "#{file:" + this.clientKey.getAbsolutePath() + "}");
                attributeMapping.put("private_key", "--key");
            } else if (clientAuthConfig.get("private_key") == null) {
                attributeMapping.put("private_key", "--key");
            }
            if (this.clientKeyPass != null) {
                clientAuthConfig.put("private_key_password", this.clientKeyPass);
            }
            if (this.caCert != null) {
                config.put("trusted_cas", "#{file:" + this.caCert.getAbsolutePath() + "}");
                attributeMapping.put("trusted_cas", "--ca-cert");
            } else if (clientAuthConfig.get("trusted_cas") == null) {
                attributeMapping.put("trusted_cas", "--ca-cert");
            }
            config.put("verify_hostnames", this.insecure == false);
            config.put("client_auth", clientAuthConfig);
            try {
                return TLSConfig.parse((Map)config);
            }
            catch (ConfigValidationException e) {
                this.validationErrors.add(null, e);
                this.validationErrors.mapKeys(attributeMapping).throwExceptionForPresentErrors();
            }
        }
        return null;
    }

    private String getHumanReadableErrorMessage(FailedConnectionException e) {
        if (e.getCause() instanceof SSLHandshakeException) {
            if (e.getMessage().contains("unable to find valid certification path to requested target")) {
                return "Could not validate server certificate using current CA settings. Please verify that you are using the correct CA certificates. You can specify custom CA certificates using the --ca-cert option.";
            }
        } else if (e.getCause() instanceof SSLException && e.getCause().getCause() instanceof SocketException) {
            return "Connection failed: " + e.getCause().getCause().getMessage();
        }
        return e.getMessage();
    }

    private String getCertificateInfo(Collection<? extends Certificate> certificateChain) {
        StringBuilder result = new StringBuilder();
        for (Certificate certificate : certificateChain) {
            if (result.length() > 0) {
                result.append(" / ");
            }
            if (certificate instanceof X509Certificate) {
                X509Certificate x509c = (X509Certificate)certificate;
                result.append(x509c.getSubjectDN());
                continue;
            }
            if (certificate != null) {
                result.append(certificate.getClass().getName());
                continue;
            }
            result.append("null");
        }
        return result.toString();
    }

    protected String getHost() {
        return this.host;
    }
}

