/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents.pointer;

import com.floragunn.codova.documents.pointer.DocPointer;
import com.floragunn.codova.documents.pointer.PointerEvaluationException;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableList;
import java.util.List;
import java.util.Map;

public class JsonPointer
implements DocPointer {
    public static final JsonPointer ROOT = new JsonPointer(ImmutableList.empty(), "");
    private final ImmutableList<ReferenceToken> tokens;
    private final String source;
    private JsonPointer parent;

    public static JsonPointer parse(String jsonPointer) throws ConfigValidationException {
        if (jsonPointer.length() == 0) {
            return ROOT;
        }
        if (jsonPointer.charAt(0) != '/') {
            throw new ConfigValidationException(new ValidationError(null, "Invalid character at first position"));
        }
        String[] tokenStrings = jsonPointer.substring(1).split("/");
        ImmutableList.Builder<ReferenceToken> tokens = new ImmutableList.Builder<ReferenceToken>(tokenStrings.length);
        for (int i = 0; i < tokenStrings.length; ++i) {
            tokens.add(new ReferenceToken(tokenStrings[i]));
        }
        return new JsonPointer(tokens.build(), jsonPointer);
    }

    JsonPointer(ImmutableList<ReferenceToken> tokens, String source) {
        this.tokens = tokens;
        this.source = source;
        if (tokens.size() == 1) {
            this.parent = ROOT;
        }
    }

    @Override
    public Object getPointedValue(Object objectTreeNode) throws PointerEvaluationException {
        int tokenSize = this.tokens.size();
        if (tokenSize == 0) {
            return objectTreeNode;
        }
        Object currentNode = objectTreeNode;
        for (int i = 0; i < tokenSize; ++i) {
            ReferenceToken token = (ReferenceToken)this.tokens.get(i);
            if (currentNode instanceof List) {
                if (token.index == -2) {
                    throw new PointerEvaluationException(this.getAncestor(i + 1) + " is not a valid array index");
                }
                if (token.index == -1) {
                    throw new PointerEvaluationException(this.getAncestor(i + 1) + " cannot be used for reading a value from an index");
                }
                List list = (List)currentNode;
                if (list.size() > token.index) {
                    currentNode = list.get(token.index);
                    continue;
                }
                throw new PointerEvaluationException(token.index + " out of bounds for array of size " + list.size() + " at " + this.getAncestor(i));
            }
            if (currentNode instanceof Map) {
                currentNode = ((Map)currentNode).get(token.content);
                continue;
            }
            if (currentNode == null) {
                throw new PointerEvaluationException(this.getAncestor(i) + " is null. Expected array or object.");
            }
            throw new PointerEvaluationException(this.getAncestor(i) + " points to a scalar value. Expected array or object.");
        }
        return currentNode;
    }

    @Override
    public void setPointedValue(Object objectTreeNode, Object newValue) throws PointerEvaluationException {
        Object containerNode = this.getParent().getPointedValue(objectTreeNode);
        ReferenceToken token = (ReferenceToken)this.tokens.get(this.tokens.size() - 1);
        if (containerNode instanceof List) {
            List list = (List)containerNode;
            if (token.index == -2) {
                throw new PointerEvaluationException(token.content + " is not a valid array index");
            }
            if (token.index == -1) {
                list.add(newValue);
            } else if (token.index < list.size()) {
                list.set(token.index, newValue);
            }
        } else if (containerNode instanceof Map) {
            Map map = (Map)containerNode;
            map.put(token.content, newValue);
        } else {
            if (containerNode == null) {
                throw new PointerEvaluationException(this.getParent() + " is null. Expected array or object.");
            }
            throw new PointerEvaluationException(this.getParent() + " points to a scalar value. Expected array or object.");
        }
    }

    @Override
    public void addAtPointedValue(Object objectTreeNode, Object newValue) throws PointerEvaluationException {
        Object containerNode = this.getParent().getPointedValue(objectTreeNode);
        ReferenceToken token = (ReferenceToken)this.tokens.get(this.tokens.size() - 1);
        if (containerNode instanceof List) {
            List list = (List)containerNode;
            if (token.index == -2) {
                throw new PointerEvaluationException(token.content + " is not a valid array index");
            }
            if (token.index == -1) {
                list.add(newValue);
            } else if (token.index < list.size()) {
                list.add(token.index, newValue);
            }
        } else if (containerNode instanceof Map) {
            Map map = (Map)containerNode;
            map.put(token.content, newValue);
        } else {
            if (containerNode == null) {
                throw new PointerEvaluationException(this.getParent() + " is null. Expected array or object.");
            }
            throw new PointerEvaluationException(this.getParent() + " points to a scalar value. Expected array or object.");
        }
    }

    @Override
    public Object removePointedValue(Object objectTreeNode) throws PointerEvaluationException {
        Object containerNode = this.getParent().getPointedValue(objectTreeNode);
        ReferenceToken token = (ReferenceToken)this.tokens.get(this.tokens.size() - 1);
        if (containerNode instanceof List) {
            List list = (List)containerNode;
            if (token.index == -2) {
                return null;
            }
            if (token.index == -1) {
                return null;
            }
            if (token.index < list.size()) {
                return list.remove(token.index);
            }
            return null;
        }
        if (containerNode instanceof Map) {
            Map map = (Map)containerNode;
            return map.remove(token.content);
        }
        if (containerNode == null) {
            throw new PointerEvaluationException(this.getParent() + " is null. Expected array or object.");
        }
        throw new PointerEvaluationException(this.getParent() + " points to a scalar value. Expected array or object.");
    }

    public JsonPointer with(String referenceToken) {
        String escaped = ReferenceToken.escape(referenceToken);
        return new JsonPointer(this.tokens.with(new ReferenceToken(escaped)), this.source + "/" + escaped);
    }

    public JsonPointer with(int referenceToken) {
        return new JsonPointer(this.tokens.with(new ReferenceToken(referenceToken)), this.source + "/" + referenceToken);
    }

    public boolean isRoot() {
        return this.tokens.isEmpty();
    }

    public String toString() {
        return this.source;
    }

    @Override
    public DocPointer getParent() {
        JsonPointer parent = this.parent;
        if (parent == null) {
            if (this.tokens.size() == 0) {
                return null;
            }
            if (this.tokens.size() == 1) {
                return ROOT;
            }
            this.parent = parent = new JsonPointer((ImmutableList<ReferenceToken>)this.tokens.subList(0, this.tokens.size() - 1), this.source.substring(0, this.source.lastIndexOf(47)));
            return parent;
        }
        return parent;
    }

    public DocPointer getAncestor(int generation) {
        if (generation >= this.tokens.size() && generation < 0) {
            throw new IllegalArgumentException("Invalid generation parameter: " + generation);
        }
        if (generation == this.tokens.size()) {
            return this;
        }
        if (generation == this.tokens.size() - 1) {
            return this.getParent();
        }
        DocPointer ancestor = this.getParent();
        for (int i = this.tokens.size() - 1; i > generation; --i) {
            ancestor = ancestor.getParent();
        }
        return ancestor;
    }

    public int hashCode() {
        return this.tokens.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JsonPointer)) {
            return false;
        }
        JsonPointer other = (JsonPointer)obj;
        return this.tokens.equals(other.tokens);
    }

    static class ReferenceToken {
        static final int LAST = -1;
        static final int NON_NUMERIC = -2;
        private final String source;
        private final String content;
        private final int index;

        ReferenceToken(String tokenString) {
            this.source = tokenString;
            this.content = ReferenceToken.unescapeTokenString(tokenString);
            this.index = ReferenceToken.parseToIndex(tokenString);
        }

        ReferenceToken(int index) {
            this.content = index == -1 ? "-" : String.valueOf(index);
            this.source = this.content;
            this.index = index;
        }

        static String escape(String tokenString) {
            if (!ReferenceToken.needsEscaping(tokenString)) {
                return tokenString;
            }
            StringBuilder result = new StringBuilder(tokenString.length() + 10);
            block4: for (int i = 0; i < tokenString.length(); ++i) {
                char c = tokenString.charAt(i);
                switch (c) {
                    case '~': {
                        result.append("~0");
                        continue block4;
                    }
                    case '/': {
                        result.append("~1");
                        continue block4;
                    }
                    default: {
                        result.append(c);
                    }
                }
            }
            return result.toString();
        }

        static boolean needsEscaping(String tokenString) {
            int length = tokenString.length();
            for (int i = 0; i < length; ++i) {
                switch (tokenString.charAt(i)) {
                    case '/': 
                    case '~': {
                        return true;
                    }
                }
            }
            return false;
        }

        private static String unescapeTokenString(String tokenString) {
            if (tokenString.indexOf(126) == -1) {
                return tokenString;
            }
            return tokenString.replace("~1", "/").replace("~0", "~");
        }

        public String toString() {
            return this.source;
        }

        private static int parseToIndex(String tokenString) {
            if (tokenString.equals("-")) {
                return -1;
            }
            if (ReferenceToken.isNumeric(tokenString)) {
                return Integer.parseInt(tokenString);
            }
            return -2;
        }

        private static boolean isNumeric(String tokenString) {
            int length = tokenString.length();
            if (length == 0) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                char c = tokenString.charAt(i);
                if (c >= '0' && c <= '9') continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.content.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ReferenceToken)) {
                return false;
            }
            ReferenceToken other = (ReferenceToken)obj;
            return this.content.equals(other.content);
        }
    }
}

