/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.commands;

import com.floragunn.encryption.at.rest.api.InitializeClusterKeyResponse;
import com.floragunn.encryption.at.rest.client.ApiException;
import com.floragunn.encryption.at.rest.client.EnRestClient;
import com.floragunn.encryption.at.rest.client.FailedConnectionException;
import com.floragunn.encryption.at.rest.client.InvalidResponseException;
import com.floragunn.encryption.at.rest.client.ServiceUnavailableException;
import com.floragunn.encryption.at.rest.client.UnauthorizedException;
import com.floragunn.encryption.at.rest.commands.ConnectingCommand;
import com.floragunn.encryption.at.rest.enctl.EnctlException;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="initialize-cluster", description={"Initialize cluster with cluster key"})
public class InitializeCluster
extends ConnectingCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--pk-file"}, required=true, arity="1", description={"Path to the private cluster key file"})
    File pkFile;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Integer call() {
        try {
            EnRestClient client = this.getClient().debug(this.debug);
            try {
                if (!this.pkFile.exists()) {
                    throw new EnctlException("No such file " + String.valueOf(this.pkFile));
                }
                byte[] pkFileBytes = Files.readAllBytes(this.pkFile.toPath());
                try {
                    PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(pkFileBytes));
                    KeyFactory kf = KeyFactory.getInstance("RSA");
                    kf.generatePrivate(spec);
                }
                catch (Exception e) {
                    System.out.println("Not a valid RSA private key in " + String.valueOf(this.pkFile));
                    if (this.debug || this.verbose) {
                        System.out.println(e);
                    }
                    Integer n = 1;
                    if (client == null) return n;
                    client.close();
                    return n;
                }
                InitializeClusterKeyResponse response = client.initializeClusterKey((Map<String, Object>)ImmutableMap.of((Object)"key", (Object)new String(pkFileBytes)));
                System.out.println("Cluster initialized with key from " + String.valueOf(this.pkFile));
                System.out.println(response.getContent());
                Integer n = 0;
                return n;
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable;
                        throwable.addSuppressed(throwable2);
                    }
                }
            }
        }
        catch (EnctlException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (InvalidResponseException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (FailedConnectionException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (ServiceUnavailableException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (UnauthorizedException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (ApiException | IOException e) {
            System.err.println(e.getMessage());
            return 1;
        }
    }
}

