/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections;

import com.floragunn.fluent.collections.UnmodifiableCollection;
import com.floragunn.fluent.collections.UnmodifiableIterator;
import java.util.Collection;
import java.util.Set;

public interface UnmodifiableSet<V>
extends Set<V>,
UnmodifiableCollection<V> {
    public static <V> UnmodifiableSet<V> of(final Set<V> set) {
        if (set instanceof UnmodifiableSet) {
            return (UnmodifiableSet)set;
        }
        return new UnmodifiableSet<V>(){

            @Override
            public int size() {
                return set.size();
            }

            @Override
            public boolean isEmpty() {
                return set.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return set.contains(o);
            }

            @Override
            public UnmodifiableIterator<V> iterator() {
                return UnmodifiableIterator.of(set.iterator());
            }

            @Override
            public Object[] toArray() {
                return set.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return set.toArray(a);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return set.containsAll(c);
            }
        };
    }

    @Override
    @Deprecated
    default public boolean add(V e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean addAll(Collection<? extends V> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void clear() {
        throw new UnsupportedOperationException();
    }
}

