/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSetImpl;
import com.floragunn.fluent.collections.UnmodifiableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;

public interface ImmutableSet<E>
extends UnmodifiableSet<E> {
    public static <E> ImmutableSet<E> empty() {
        return ImmutableSetImpl.empty();
    }

    public static <E> ImmutableSet<E> of(E e) {
        return ImmutableSetImpl.of(e);
    }

    public static <E> ImmutableSet<E> of(E e1, E e2) {
        return ImmutableSetImpl.of(e1, e2);
    }

    public static <E> ImmutableSet<E> ofNonNull(E e1, E e2) {
        return ImmutableSetImpl.ofNonNull(e1, e2);
    }

    @SafeVarargs
    public static <E> ImmutableSet<E> of(E e, E ... more) {
        return ImmutableSetImpl.of(e, more);
    }

    @SafeVarargs
    public static <E> ImmutableSet<E> ofArray(E ... array) {
        return ImmutableSetImpl.ofArray(array);
    }

    public static <E> ImmutableSet<E> of(Iterable<? extends E> iterable) {
        return ImmutableSetImpl.of(iterable);
    }

    public static <E> ImmutableSet<E> of(Collection<? extends E> collection) {
        return ImmutableSetImpl.of(collection);
    }

    public static <E> ImmutableSet<E> of(Set<E> set, E other) {
        return ImmutableSetImpl.of(set, other);
    }

    public static <E> ImmutableSet<E> flattenDeep(Collection<?> collection, Function<Object, E> mappingFunction) {
        return ImmutableSetImpl.flattenDeep(collection, mappingFunction);
    }

    public static <C, E> ImmutableSet<E> map(Collection<C> collection, Function<C, E> mappingFunction) {
        return ImmutableSetImpl.map(collection, mappingFunction);
    }

    public static <E> Collector<E, ?, ImmutableSet<E>> collector() {
        return ImmutableSetImpl.collector();
    }

    public ImmutableSet<E> with(E var1);

    public ImmutableSet<E> with(Collection<? extends E> var1);

    public ImmutableSet<E> with(E ... var1);

    public ImmutableSet<E> matching(Predicate<E> var1);

    public Iterable<E> iterateMatching(Predicate<E> var1);

    default public ImmutableSet<E> withoutMatching(Predicate<E> predicate) {
        return this.matching(predicate.negate());
    }

    public ImmutableSet<E> intersection(Set<? extends E> var1);

    public ImmutableSet<E> without(Collection<? extends E> var1);

    public ImmutableSet<E> without(E var1);

    public <O> ImmutableSet<O> map(Function<E, O> var1);

    public <O> ImmutableSet<O> mapFlat(Function<E, Collection<O>> var1);

    public ImmutableList<E> toList();

    public <V> ImmutableMap<E, V> toMap(Function<E, V> var1);

    public boolean forAllApplies(Predicate<E> var1);

    public boolean forAnyApplies(Predicate<E> var1);

    public boolean containsAny(Collection<? extends E> var1);

    public E only();

    public E any();

    public String toShortString();

    public static class Builder<E>
    implements Iterable<E> {
        private ImmutableSetImpl.InternalBuilder<E> internalBuilder;
        private final ImmutableSet<E> initialImmutableSet;

        public Builder() {
            this.initialImmutableSet = null;
            this.internalBuilder = new ImmutableSetImpl.HashArrayBackedSet.Builder(16);
        }

        public Builder(int expectedNumberOfElements) {
            this.initialImmutableSet = null;
            this.internalBuilder = expectedNumberOfElements <= 16 ? new ImmutableSetImpl.HashArrayBackedSet.Builder(16) : (expectedNumberOfElements <= 64 ? new ImmutableSetImpl.HashArrayBackedSet.Builder(64) : (expectedNumberOfElements <= 256 ? new ImmutableSetImpl.HashArrayBackedSet.Builder(256) : new ImmutableSetImpl.SetBackedSet.Builder(expectedNumberOfElements)));
        }

        public Builder(Collection<E> initialContent) {
            if (initialContent instanceof ImmutableSet) {
                this.initialImmutableSet = (ImmutableSet)initialContent;
            } else {
                this.initialImmutableSet = null;
                this.initFrom(initialContent);
            }
        }

        public Builder(E[] initialContent) {
            this.initialImmutableSet = null;
            if (initialContent.length <= 16) {
                this.internalBuilder = new ImmutableSetImpl.HashArrayBackedSet.Builder(16);
                for (int i = 0; i < initialContent.length; ++i) {
                    this.internalBuilder = this.internalBuilder.with(initialContent[i]);
                }
            } else if (initialContent.length <= 64) {
                this.internalBuilder = new ImmutableSetImpl.HashArrayBackedSet.Builder(64);
                for (int i = 0; i < initialContent.length; ++i) {
                    this.internalBuilder = this.internalBuilder.with(initialContent[i]);
                }
            } else if (initialContent.length <= 256) {
                this.internalBuilder = new ImmutableSetImpl.HashArrayBackedSet.Builder(256);
                for (int i = 0; i < initialContent.length; ++i) {
                    this.internalBuilder = this.internalBuilder.with(initialContent[i]);
                }
            } else {
                this.internalBuilder = new ImmutableSetImpl.SetBackedSet.Builder<E>(Arrays.asList(initialContent));
            }
        }

        public Builder<E> with(E e) {
            if (this.internalBuilder == null) {
                this.initFrom(this.initialImmutableSet);
            }
            this.internalBuilder = this.internalBuilder.with(e);
            return this;
        }

        public Builder<E> with(Collection<E> collection) {
            if (collection.isEmpty()) {
                return this;
            }
            if (this.internalBuilder == null) {
                this.initFrom(this.initialImmutableSet);
            }
            this.internalBuilder = this.internalBuilder.with(collection);
            return this;
        }

        public boolean add(E e) {
            if (this.internalBuilder == null) {
                this.initFrom(this.initialImmutableSet);
            }
            int size = this.internalBuilder.size();
            this.internalBuilder = this.internalBuilder.with(e);
            return size != this.internalBuilder.size();
        }

        public boolean addAll(Collection<E> collection) {
            if (collection.isEmpty()) {
                return false;
            }
            if (this.internalBuilder == null) {
                this.initFrom(this.initialImmutableSet);
            }
            int size = this.internalBuilder.size();
            for (E e : collection) {
                this.internalBuilder = this.internalBuilder.with(e);
            }
            return size != this.internalBuilder.size();
        }

        public boolean addAll(E ... array) {
            if (array.length == 0) {
                return false;
            }
            if (this.internalBuilder == null) {
                this.initFrom(this.initialImmutableSet);
            }
            int size = this.internalBuilder.size();
            for (int i = 0; i < array.length; ++i) {
                this.internalBuilder = this.internalBuilder.with(array[i]);
            }
            return size != this.internalBuilder.size();
        }

        public boolean remove(E e) {
            if (this.internalBuilder == null) {
                this.initFrom(this.initialImmutableSet);
            }
            return this.internalBuilder.remove(e);
        }

        public void clear() {
            if (this.internalBuilder == null) {
                this.internalBuilder = new ImmutableSetImpl.HashArrayBackedSet.Builder(16);
            } else {
                this.internalBuilder.clear();
            }
        }

        public boolean contains(E e) {
            if (this.internalBuilder == null) {
                return this.initialImmutableSet.contains(e);
            }
            return this.internalBuilder.contains(e);
        }

        public boolean containsAny(Set<E> set) {
            if (this.internalBuilder == null) {
                return this.initialImmutableSet.containsAny(set);
            }
            return this.internalBuilder.containsAny(set);
        }

        public boolean containsAll(Set<E> set) {
            if (this.internalBuilder == null) {
                return this.initialImmutableSet.containsAll(set);
            }
            return this.internalBuilder.containsAll(set);
        }

        public ImmutableSet<E> build() {
            if (this.internalBuilder == null) {
                return this.initialImmutableSet;
            }
            return this.internalBuilder.build();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.internalBuilder == null) {
                this.initFrom(this.initialImmutableSet);
            }
            return this.internalBuilder.iterator();
        }

        public int size() {
            if (this.internalBuilder == null) {
                return this.initialImmutableSet.size();
            }
            return this.internalBuilder.size();
        }

        public E any() {
            if (this.internalBuilder == null) {
                return this.initialImmutableSet.any();
            }
            return this.internalBuilder.any();
        }

        public String toString() {
            if (this.internalBuilder == null) {
                return this.initialImmutableSet.toString();
            }
            return this.internalBuilder.toString();
        }

        public String toDebugString() {
            return this.internalBuilder != null ? this.internalBuilder.getClass() + " " + this.internalBuilder.toDebugString() : "initial state";
        }

        private void initFrom(Collection<E> initialContent) {
            if (initialContent instanceof ImmutableSetImpl.HashArrayBackedSet) {
                this.internalBuilder = new ImmutableSetImpl.HashArrayBackedSet.Builder((ImmutableSetImpl.HashArrayBackedSet)initialContent);
            } else if (initialContent.size() <= 16) {
                this.internalBuilder = new ImmutableSetImpl.HashArrayBackedSet.Builder(16);
                for (E e : initialContent) {
                    this.internalBuilder = this.internalBuilder.with(e);
                }
            } else if (initialContent.size() <= 64) {
                this.internalBuilder = new ImmutableSetImpl.HashArrayBackedSet.Builder(64);
                for (E e : initialContent) {
                    this.internalBuilder = this.internalBuilder.with(e);
                }
            } else if (initialContent.size() <= 256) {
                this.internalBuilder = new ImmutableSetImpl.HashArrayBackedSet.Builder(256);
                for (E e : initialContent) {
                    this.internalBuilder = this.internalBuilder.with(e);
                }
            } else {
                this.internalBuilder = new ImmutableSetImpl.SetBackedSet.Builder<E>(initialContent);
            }
        }
    }
}

