/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections;

import com.floragunn.fluent.collections.UnmodifiableCollection;
import com.floragunn.fluent.collections.UnmodifiableIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public interface UnmodifiableList<V>
extends List<V>,
UnmodifiableCollection<V> {
    public static <V> UnmodifiableList<V> of(final List<V> list) {
        if (list instanceof UnmodifiableList) {
            return (UnmodifiableList)list;
        }
        return new UnmodifiableList<V>(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return list.contains(o);
            }

            @Override
            public UnmodifiableIterator<V> iterator() {
                return UnmodifiableIterator.of(list.iterator());
            }

            @Override
            public Object[] toArray() {
                return list.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return list.toArray(a);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return list.containsAll(c);
            }

            @Override
            public V get(int index) {
                return list.get(index);
            }

            @Override
            public int indexOf(Object o) {
                return list.indexOf(o);
            }

            @Override
            public int lastIndexOf(Object o) {
                return list.lastIndexOf(o);
            }

            @Override
            public ListIterator<V> listIterator() {
                return list.listIterator();
            }

            @Override
            public ListIterator<V> listIterator(int index) {
                return list.listIterator(index);
            }

            @Override
            public List<V> subList(int fromIndex, int toIndex) {
                return UnmodifiableList.of(list.subList(fromIndex, toIndex));
            }
        };
    }

    @Override
    @Deprecated
    default public boolean addAll(int index, Collection<? extends V> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<V> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super V> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public V set(int index, V element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void add(int index, V element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super V> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean add(V e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean addAll(Collection<? extends V> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    default public V remove(int index) {
        throw new UnsupportedOperationException();
    }
}

