/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.commands;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="create-cluster-keypair", description={"Create a new cluster key pair"})
public class CreateClusterKeyPair
implements Callable<Integer> {
    @CommandLine.Option(names={"--apache2"}, description={"Show the Apache 2 license text"})
    boolean apache2;

    @Override
    public Integer call() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(4096);
        KeyPair keypair = kpg.generateKeyPair();
        PublicKey publickey = keypair.getPublic();
        PrivateKey privateKey = keypair.getPrivate();
        UUID uuid = UUID.randomUUID();
        Path publicKeyPath = Paths.get("public_cluster_key_" + String.valueOf(uuid) + ".pubkey", new String[0]);
        Path publicKeyTemplatePath = Paths.get("elasticsearch_yaml_" + String.valueOf(uuid) + ".yml", new String[0]);
        Path privateKeyPath = Paths.get("secret_cluster_key_" + String.valueOf(uuid) + ".seckey", new String[0]);
        System.out.println("Created a new RSA key pair with UUID " + String.valueOf(uuid));
        System.out.println("Public key will be stored in " + String.valueOf(publicKeyPath));
        System.out.println("Public key config template will be stored in " + String.valueOf(publicKeyTemplatePath));
        System.out.println("Secret key will be stored in " + String.valueOf(privateKeyPath));
        String template = "# Put this in elasticsearch.yml\n# UUID " + String.valueOf(uuid) + "\nencryption_at_rest.public_cluster_key: " + Base64.getEncoder().encodeToString(publickey.getEncoded()) + "\nencryption_at_rest.enabled: true";
        Files.write(publicKeyPath, Base64.getEncoder().encode(publickey.getEncoded()), new OpenOption[0]);
        Files.write(publicKeyTemplatePath, template.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(privateKeyPath, Base64.getEncoder().encode(privateKey.getEncoded()), new OpenOption[0]);
        return 0;
    }
}

