/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public interface UnmodifiableIterator<E>
extends Iterator<E> {
    public static final UnmodifiableIterator<?> EMPTY = new UnmodifiableIterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }
    };

    public static <E> UnmodifiableIterator<E> of(final Iterator<E> iterator) {
        if (iterator instanceof UnmodifiableIterator) {
            return (UnmodifiableIterator)iterator;
        }
        return new UnmodifiableIterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                return iterator.next();
            }
        };
    }

    public static <E> UnmodifiableIterator<E> of(final E element) {
        return new UnmodifiableIterator<E>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 1;
            }

            @Override
            public E next() {
                if (this.i == 0) {
                    ++this.i;
                    return element;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @SafeVarargs
    public static <E> UnmodifiableIterator<E> of(final E ... elements) {
        return new UnmodifiableIterator<E>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < elements.length;
            }

            @Override
            public E next() {
                if (this.i >= elements.length) {
                    throw new NoSuchElementException();
                }
                Object element = elements[this.i];
                ++this.i;
                return element;
            }
        };
    }

    public static <E> UnmodifiableIterator<E> empty() {
        UnmodifiableIterator<?> result = EMPTY;
        return result;
    }

    @Override
    @Deprecated
    default public void remove() {
        throw new UnsupportedOperationException();
    }
}

