/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.ValidationError;
import java.util.LinkedHashMap;
import java.util.Map;

public class DocumentParseException
extends ConfigValidationException {
    private static final long serialVersionUID = 7108776044115873652L;

    public DocumentParseException(ValidationError validationError) {
        super(validationError);
    }

    public DocumentParseException(JsonProcessingException jsonProcessingException, Format format) {
        this(new DocParseError(null, jsonProcessingException, format));
    }

    public DocumentParseException(String attribute, JsonProcessingException jsonProcessingException, Format format) {
        this(new DocParseError(attribute, jsonProcessingException, format));
    }

    public static class DocParseError
    extends ValidationError {
        private JsonLocation jsonLocation;
        private String context;

        public DocParseError(String attribute, JsonProcessingException jsonProcessingException, Format format) {
            super(attribute, "Invalid " + format.getName() + " document: " + jsonProcessingException.getOriginalMessage());
            this.cause(jsonProcessingException);
            this.jsonLocation = jsonProcessingException.getLocation();
            if (jsonProcessingException instanceof JsonParseException) {
                this.context = ((JsonParseException)jsonProcessingException).getRequestPayloadAsString();
            }
        }

        public DocParseError(String attribute, String message, JsonLocation jsonLocation, String context) {
            super(attribute, message);
            this.jsonLocation = jsonLocation;
            this.context = context;
        }

        @Override
        public Map<String, Object> toBasicObject() {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("error", this.getMessage());
            if (this.jsonLocation != null) {
                result.put("line", this.jsonLocation.getLineNr());
                result.put("column", this.jsonLocation.getColumnNr());
            }
            if (this.context != null) {
                result.put("context", this.context);
            }
            return result;
        }

        @Override
        public String toValidationErrorsOverviewString() {
            if (this.jsonLocation != null) {
                return this.getMessage() + "; line: " + this.jsonLocation.getLineNr() + "; column: " + this.jsonLocation.getColumnNr();
            }
            return this.getMessage();
        }
    }
}

