/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.validation;

import com.floragunn.codova.documents.Document;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;

public class ConfigValidationException
extends Exception
implements Document<ConfigValidationException> {
    private static final long serialVersionUID = 8874565903177850402L;
    private ValidationErrors validationErrors;

    public ConfigValidationException(ValidationErrors validationErrors) {
        super(ConfigValidationException.getMessage(validationErrors), validationErrors.getCause());
        this.validationErrors = validationErrors;
    }

    public ConfigValidationException(Multimap<String, ValidationError> validationErrors) {
        this(new ValidationErrors(validationErrors));
    }

    public ConfigValidationException(ValidationError validationError) {
        this((Multimap<String, ValidationError>)ImmutableListMultimap.of((Object)validationError.getAttribute(), (Object)validationError));
    }

    public ValidationErrors getValidationErrors() {
        return this.validationErrors;
    }

    private static String getMessage(ValidationErrors validationErrors) {
        int size = validationErrors.size();
        if (size == 1) {
            ValidationError onlyError = validationErrors.getOnlyValidationError();
            if (onlyError.getAttribute() != null && !"_".equals(onlyError.getAttribute())) {
                return "'" + onlyError.getAttribute() + "': " + onlyError.getMessage();
            }
            return onlyError.getMessage();
        }
        return size + " errors; see detail.";
    }

    @Override
    public String toString() {
        return "ConfigValidationException: " + this.getMessage() + "\n" + this.validationErrors;
    }

    public String toDebugString() {
        return "ConfigValidationException: " + this.getMessage() + "\n" + this.validationErrors.toDebugString();
    }

    public Map<String, Object> toMap() {
        return this.validationErrors.toMap();
    }

    @Override
    public Object toBasicObject() {
        return this.validationErrors.toBasicObject();
    }
}

