/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.commands;

import com.floragunn.encryption.at.rest.client.EnRestClient;
import com.floragunn.encryption.at.rest.commands.ConnectingCommand;
import com.floragunn.encryption.at.rest.enctl.EnctlConfig;
import com.floragunn.encryption.at.rest.enctl.EnctlException;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="connect", description={"Tries to connect to a cluster and persists this connection for subsequent commands"})
public class Connect
extends ConnectingCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", arity="0..1", description={"Name of the server to connect to."})
    String server;

    @Override
    public Integer call() {
        EnRestClient client = this.getClient();
        try {
            EnctlConfig.Cluster cluster = new EnctlConfig.Cluster(client.getHttpHost().getHostName(), client.getHttpHost().getPort(), client.getTlsConfig());
            String clusterConfigId = this.getSelectedClusterId();
            if (clusterConfigId == null) {
                clusterConfigId = this.getHost();
            }
            cluster.setClusterId(clusterConfigId);
            cluster.write(this.getConfigDir());
            this.writeSelectedClusterId(clusterConfigId);
            Integer n = 0;
            if (client != null) {
                client.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (EnctlException e) {
                System.err.println(e.getMessage());
                if (this.debug) {
                    e.printStackTrace();
                }
                return 1;
            }
        }
    }

    @Override
    protected String getHost() {
        if (this.host != null) {
            return this.host;
        }
        return this.server;
    }
}

