/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.commands;

import com.floragunn.encryption.at.rest.api.InitializeClusterKeyResponse;
import com.floragunn.encryption.at.rest.client.ApiException;
import com.floragunn.encryption.at.rest.client.EnRestClient;
import com.floragunn.encryption.at.rest.client.FailedConnectionException;
import com.floragunn.encryption.at.rest.client.InvalidResponseException;
import com.floragunn.encryption.at.rest.client.ServiceUnavailableException;
import com.floragunn.encryption.at.rest.client.UnauthorizedException;
import com.floragunn.encryption.at.rest.commands.ConnectingCommand;
import com.floragunn.encryption.at.rest.enctl.EnctlException;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="display-state", description={"Show all initialization status"})
public class GetState
extends ConnectingCommand
implements Callable<Integer> {
    @Override
    public Integer call() {
        EnRestClient client = this.getClient().debug(this.debug);
        try {
            InitializeClusterKeyResponse response = client.getState();
            for (String key : response.getContent().keySet()) {
                System.out.println(key + "=" + String.valueOf(response.getContent().get(key)));
            }
            Integer n = 0;
            if (client != null) {
                client.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (EnctlException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (InvalidResponseException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (FailedConnectionException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (ServiceUnavailableException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (UnauthorizedException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            catch (ApiException e) {
                System.err.println(e.getMessage());
                return 1;
            }
        }
    }
}

