/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.config.templates;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import java.util.Map;

public interface AttributeSource {
    public Object getAttributeValue(String var1);

    public static AttributeSource joined(AttributeSource ... attributeSources) {
        final ImmutableList<AttributeSource> sources = ImmutableList.ofArray(attributeSources);
        return new AttributeSource(){

            @Override
            public Object getAttributeValue(String attributeName) {
                for (AttributeSource source : sources) {
                    Object result = source.getAttributeValue(attributeName);
                    if (result == null) continue;
                    return result;
                }
                return null;
            }
        };
    }

    public static AttributeSource from(final Map<String, Object> map) {
        return new AttributeSource(){

            @Override
            public Object getAttributeValue(String attributeName) {
                return this.getAttributeValue(attributeName, map, 0);
            }

            private Object getAttributeValue(String attributeName, Map<?, ?> map2, int depth) {
                String firstPart;
                Object value = map2.get(attributeName);
                if (value != null) {
                    return value;
                }
                if (depth > 100) {
                    return null;
                }
                int dot = attributeName.indexOf(46);
                if (dot != -1 && (value = map2.get(firstPart = attributeName.substring(0, dot))) instanceof Map) {
                    return this.getAttributeValue(attributeName.substring(dot + 1), (Map)value, depth + 1);
                }
                return null;
            }
        };
    }

    public static AttributeSource of(String attribute, Object value) {
        return AttributeSource.from(ImmutableMap.of(attribute, value));
    }
}

