/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents.patch;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocUpdateException;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.UnparsedDocument;
import com.floragunn.codova.documents.patch.JsonPatch;
import com.floragunn.codova.documents.patch.JsonPathPatch;
import com.floragunn.codova.documents.patch.MergePatch;
import com.floragunn.codova.documents.patch.SimplePathPatch;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.ValidationError;

public interface DocPatch
extends Document<Object> {
    public DocNode apply(DocNode var1) throws DocUpdateException;

    public String getMediaType();

    public static DocPatch parse(String contentType, String content) throws ConfigValidationException {
        if (contentType.equalsIgnoreCase("application/merge-patch+json")) {
            return new MergePatch(DocNode.parse(Format.JSON).from(content));
        }
        if (contentType.equalsIgnoreCase("application/json-patch+json")) {
            return new JsonPatch(DocNode.parse(Format.JSON).from(content));
        }
        if (contentType.equalsIgnoreCase("application/x-json-path-patch+json")) {
            return new JsonPathPatch(DocNode.parse(Format.JSON).from(content));
        }
        if (contentType.equalsIgnoreCase("application/x-simple-path-patch+json")) {
            return new SimplePathPatch(DocNode.parse(Format.JSON).from(content));
        }
        throw new ConfigValidationException(new ValidationError(null, "Unsupported patch type: " + contentType));
    }

    public static DocPatch parse(UnparsedDocument<?> unparsedDoc) throws ConfigValidationException {
        if (unparsedDoc.getMediaType().equalsIgnoreCase("application/merge-patch+json")) {
            return new MergePatch(DocNode.parse(unparsedDoc));
        }
        if (unparsedDoc.getMediaType().equalsIgnoreCase("application/json-patch+json")) {
            return new JsonPatch(DocNode.parse(unparsedDoc));
        }
        if (unparsedDoc.getMediaType().equalsIgnoreCase("application/x-json-path-patch+json")) {
            return new JsonPathPatch(DocNode.parse(unparsedDoc));
        }
        if (unparsedDoc.getMediaType().equalsIgnoreCase("application/x-simple-path-patch+json")) {
            return new SimplePathPatch(DocNode.parse(unparsedDoc));
        }
        throw new ConfigValidationException(new ValidationError(null, "Unsupported patch type: " + unparsedDoc.getMediaType()));
    }

    public static DocPatch parseTyped(DocNode docNode) throws ConfigValidationException {
        String contentType = docNode.getAsString("type");
        if (contentType.equalsIgnoreCase("application/merge-patch+json")) {
            return new MergePatch(docNode.getAsNode("content"));
        }
        if (contentType.equalsIgnoreCase("application/json-patch+json")) {
            return new JsonPatch(docNode.getAsNode("content"));
        }
        if (contentType.equalsIgnoreCase("application/x-json-path-patch+json")) {
            return new JsonPathPatch(docNode.getAsNode("content"));
        }
        if (contentType.equalsIgnoreCase("application/x-simple-path-patch+json")) {
            return new SimplePathPatch(docNode.getAsNode("content"));
        }
        throw new ConfigValidationException(new ValidationError(null, "Unsupported patch type: " + contentType));
    }
}

