/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.floragunn.codova.documents.ContentType;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public abstract class UnparsedDocument<T>
implements Document<T> {
    protected final Format format;
    protected final ContentType contentType;

    public static UnparsedDocument<?> from(String source, Format format) {
        return new StringDoc(source, format);
    }

    public static UnparsedDocument<?> from(String source, ContentType contentType) {
        return new StringDoc(source, contentType);
    }

    public static UnparsedDocument<?> from(byte[] source, ContentType contentType) {
        return new BytesDoc(source, contentType);
    }

    public static UnparsedDocument<?> from(byte[] source, Format format, Charset charset) {
        return new BytesDoc(source, format, charset);
    }

    public static UnparsedDocument<?> from(byte[] source, Format format) {
        return new BytesDoc(source, format, null);
    }

    public static UnparsedDocument<?> fromJson(String json) {
        return new StringDoc(json, Format.JSON);
    }

    private UnparsedDocument(Format format, ContentType contentType) {
        this.format = format;
        this.contentType = contentType;
    }

    private UnparsedDocument(Format format) {
        this.format = format;
        this.contentType = format.getContentType();
    }

    private UnparsedDocument(ContentType contentType) {
        this.format = contentType.getFormat();
        this.contentType = contentType;
    }

    public abstract Map<String, Object> parseAsMap() throws DocumentParseException, UnexpectedDocumentStructureException;

    public abstract DocNode parseAsDocNode() throws DocumentParseException;

    public abstract Object parse() throws DocumentParseException;

    public abstract String getSourceAsString();

    public abstract JsonParser createParser() throws JsonParseException, IOException;

    public Format getFormat() {
        return this.format;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public String getMediaType() {
        return this.contentType.getMediaType();
    }

    @Override
    public Object toBasicObject() {
        return this;
    }

    public static class BytesDoc
    extends UnparsedDocument<Object> {
        private final byte[] source;
        private String sourceAsString;
        private final Charset charset;

        BytesDoc(byte[] source, ContentType contentType) {
            super(contentType);
            this.source = source;
            this.charset = contentType.getCharset();
        }

        BytesDoc(byte[] source, Format format, Charset charset) {
            super(format);
            this.source = source;
            this.charset = charset;
        }

        @Override
        public Map<String, Object> parseAsMap() throws DocumentParseException, UnexpectedDocumentStructureException {
            return DocReader.format(this.format).readObject(this.source);
        }

        @Override
        public DocNode parseAsDocNode() throws DocumentParseException {
            return DocNode.parse(this.format).from(this.source);
        }

        @Override
        public Object parse() throws DocumentParseException {
            return DocReader.format(this.format).read(this.source);
        }

        public byte[] getSource() {
            return this.source;
        }

        @Override
        public Format getFormat() {
            return this.format;
        }

        public String toString() {
            if (this.format.isBinary()) {
                return this.format.getMediaType() + ": " + this.source.length + " bytes";
            }
            return this.format.getMediaType() + ":\n" + this.getSourceAsString();
        }

        @Override
        public String getSourceAsString() {
            if (this.sourceAsString == null) {
                this.sourceAsString = this.createSourceString();
            }
            return this.sourceAsString;
        }

        @Override
        public JsonParser createParser() throws JsonParseException, IOException {
            return this.format.getJsonFactory().createParser(this.source);
        }

        private String createSourceString() {
            if (this.format.isBinary()) {
                throw new IllegalStateException("Cannot encode " + this.format + " as string");
            }
            if (this.charset != null) {
                return new String(this.source, this.charset);
            }
            if (this.checkBom(255, 254, 0, 0)) {
                return new String(this.source, 4, this.source.length - 4, Charset.forName("UTF-32LE"));
            }
            if (this.checkBom(0, 0, 255, 254)) {
                return new String(this.source, 4, this.source.length - 4, Charset.forName("UTF-32BE"));
            }
            if (this.checkBom(239, 187, 191)) {
                return new String(this.source, 3, this.source.length - 3, StandardCharsets.UTF_8);
            }
            if (this.checkBom(254, 255)) {
                return new String(this.source, 2, this.source.length - 2, StandardCharsets.UTF_16BE);
            }
            if (this.checkBom(255, 254)) {
                return new String(this.source, 2, this.source.length - 2, StandardCharsets.UTF_16LE);
            }
            return new String(this.source, this.format.getDefaultCharset());
        }

        private boolean checkBom(int b1, int b2) {
            return this.source.length >= 2 && this.source[0] == b1 && this.source[1] == b2;
        }

        private boolean checkBom(int b1, int b2, int b3) {
            return this.source.length >= 3 && this.source[0] == b1 && this.source[1] == b2 && this.source[2] == b3;
        }

        private boolean checkBom(int b1, int b2, int b3, int b4) {
            return this.source.length >= 4 && this.source[0] == b1 && this.source[1] == b2 && this.source[2] == b3 && this.source[3] == b4;
        }

        @Override
        public byte[] toBytes(Format format) {
            if (format.equals(this.format)) {
                return this.source;
            }
            return super.toBytes(format);
        }
    }

    public static class StringDoc
    extends UnparsedDocument<Object> {
        private final String source;

        public StringDoc(String source, Format format) {
            super(format);
            this.source = source;
        }

        public StringDoc(String source, ContentType format) {
            super(format);
            this.source = source;
        }

        @Override
        public Map<String, Object> parseAsMap() throws DocumentParseException, UnexpectedDocumentStructureException {
            return DocReader.format(this.format).readObject(this.source);
        }

        @Override
        public DocNode parseAsDocNode() throws DocumentParseException {
            return DocNode.parse(this.format).from(this.source);
        }

        @Override
        public Object parse() throws DocumentParseException {
            return DocReader.format(this.format).read(this.source);
        }

        public String getSource() {
            return this.source;
        }

        @Override
        public Format getFormat() {
            return this.format;
        }

        public String toString() {
            return this.format.getMediaType() + ":\n" + this.source;
        }

        @Override
        public String getSourceAsString() {
            return this.source;
        }

        @Override
        public JsonParser createParser() throws JsonParseException, IOException {
            return this.format.getJsonFactory().createParser(this.source);
        }

        @Override
        public String toString(Format format) {
            if (format.equals(this.format)) {
                return this.source;
            }
            return super.toString(format);
        }
    }
}

