/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents.patch;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.patch.DocPatch;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SimplePathPatch
implements DocPatch {
    public static final String MEDIA_TYPE = "application/x-simple-path-patch+json";
    private List<Operation> operations;

    public SimplePathPatch(Operation ... operations) {
        this.operations = Arrays.asList(operations);
    }

    SimplePathPatch(DocNode source) throws ConfigValidationException {
        if (source.isList()) {
            ValidationErrors validationErrors = new ValidationErrors();
            int i = 0;
            ArrayList<Operation> operations = new ArrayList<Operation>();
            for (DocNode element : source.toListOfNodes()) {
                try {
                    operations.add(new Operation(element));
                }
                catch (ConfigValidationException e) {
                    validationErrors.add(String.valueOf(i), e);
                }
                ++i;
            }
            validationErrors.throwExceptionForPresentErrors();
            this.operations = operations;
        } else {
            this.operations = ImmutableList.of(new Operation(source));
        }
    }

    @Override
    public Object toBasicObject() {
        return this.operations;
    }

    @Override
    public DocNode apply(DocNode targetDocument) {
        Object document = SimplePathPatch.createMutableCopy(targetDocument.toBasicObject());
        for (Operation operation : this.operations) {
            document = operation.apply(document);
        }
        return DocNode.wrap(document);
    }

    @Override
    public String getMediaType() {
        return MEDIA_TYPE;
    }

    private static Object createMutableCopy(Object object) {
        if (object instanceof Map) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(((Map)object).size());
            for (Map.Entry entry : ((Map)object).entrySet()) {
                result.put(String.valueOf(entry.getKey()), SimplePathPatch.createMutableCopy(entry.getValue()));
            }
            return result;
        }
        if (object instanceof Collection) {
            ArrayList<Object> result = new ArrayList<Object>(((Collection)object).size());
            for (Object element : (Collection)object) {
                result.add(SimplePathPatch.createMutableCopy(element));
            }
            return result;
        }
        return object;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operations == null ? 0 : this.operations.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimplePathPatch)) {
            return false;
        }
        SimplePathPatch other = (SimplePathPatch)obj;
        return !(this.operations == null ? other.operations != null : !this.operations.equals(other.operations));
    }

    public String toString() {
        return "SimplePathPatch [operations=" + this.operations + "]";
    }

    public static class Operation
    implements Document<Operation> {
        private final String pathString;
        private final List<String> path;
        private final Object set;

        public Operation(String path, Object set) {
            this.path = Splitter.on('.').splitToList(path);
            this.set = set;
            this.pathString = path;
        }

        public Operation(List<String> path, Object set) {
            this.path = path;
            this.set = set;
            this.pathString = path.stream().collect(Collectors.joining("."));
        }

        Operation(DocNode docNode) throws ConfigValidationException {
            ValidationErrors validationErrors = new ValidationErrors();
            ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors);
            this.pathString = vNode.get("path").required().asString();
            this.path = this.pathString != null ? Splitter.on('.').splitToList(this.pathString) : null;
            this.set = vNode.get("set").required().asAnything();
            validationErrors.throwExceptionForPresentErrors();
        }

        @Override
        public Object toBasicObject() {
            return ImmutableMap.of("path", this.pathString, "set", this.set);
        }

        Object apply(Object document) {
            Object targetObject = this.find(document, 0);
            if (targetObject instanceof Map) {
                Map targetMap = (Map)targetObject;
                targetMap.put(this.path.get(this.path.size() - 1), this.set);
            }
            return document;
        }

        private Object find(Object object, int i) {
            if (i >= this.path.size() - 1) {
                return object;
            }
            String element = this.path.get(i);
            if (object instanceof Map) {
                Object subObject = ((Map)object).get(element);
                if (subObject != null) {
                    return this.find(subObject, i + 1);
                }
                return null;
            }
            if (object instanceof Collection) {
                Object candidate = null;
                int candidateCount = 0;
                for (Object subObject : (Collection)object) {
                    Map subMap;
                    if (!(subObject instanceof Map) || !element.equals((subMap = (Map)subObject).get("id")) && !element.equals(subMap.get("type"))) continue;
                    candidate = subObject;
                    ++candidateCount;
                }
                if (candidateCount == 1) {
                    return this.find(candidate, i + 1);
                }
                return null;
            }
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (this.set == null ? 0 : this.set.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Operation)) {
                return false;
            }
            Operation other = (Operation)obj;
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            return !(this.set == null ? other.set != null : !this.set.equals(other.set));
        }

        public String toString() {
            return "Operation [path=" + this.path + ", set=" + this.set + "]";
        }
    }
}

