/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.commands;

import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.encryption.at.rest.client.ApiException;
import com.floragunn.encryption.at.rest.client.FailedConnectionException;
import com.floragunn.encryption.at.rest.client.InvalidResponseException;
import com.floragunn.encryption.at.rest.client.PreconditionFailedException;
import com.floragunn.encryption.at.rest.client.ServiceUnavailableException;
import com.floragunn.encryption.at.rest.client.UnauthorizedException;
import com.floragunn.encryption.at.rest.enctl.EnctlConfig;
import com.floragunn.encryption.at.rest.enctl.EnctlException;
import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import picocli.CommandLine;

public class BaseCommand {
    static final File DEFAULT_CONFIG_DIR = new File(System.getProperty("user.home"), ".search_guard_encryption_at_rest");
    @CommandLine.Option(names={"-c", "--cluster"}, description={"The ID of the cluster configuration to be used by this command"})
    String clusterIdOption;
    @CommandLine.Option(names={"--debug"}, description={"Print debug information"})
    protected boolean debug;
    @CommandLine.Option(names={"-v", "--verbose"}, description={"Print more information"})
    protected boolean verbose;
    @CommandLine.Option(names={"--enctl-config-dir"}, description={"The directory where enctl reads from and writes to its configuration"})
    File customConfigDir;
    protected final ValidationErrors validationErrors = new ValidationErrors();
    private String selectedClusterId;
    private boolean selectedClusterIdInitialized;

    protected String getSelectedClusterId() throws EnctlException {
        if (!this.selectedClusterIdInitialized) {
            if (this.clusterIdOption != null) {
                this.selectedClusterId = this.clusterIdOption;
                this.selectedClusterIdInitialized = true;
            } else {
                File configFile = new File(this.getConfigDir(), "enctl-selected-config.txt");
                try {
                    this.selectedClusterId = Files.asCharSource(configFile, Charsets.UTF_8).readFirstLine();
                    this.selectedClusterIdInitialized = true;
                    if (this.verbose || this.debug) {
                        System.out.println("Selected cluster: " + this.selectedClusterId);
                    }
                }
                catch (FileNotFoundException e) {
                    return null;
                }
                catch (IOException e) {
                    throw new EnctlException("Error while reading " + String.valueOf(configFile), e);
                }
            }
        }
        return this.selectedClusterId;
    }

    protected void writeSelectedClusterId(String selectedClusterId) throws EnctlException {
        File configFile = new File(this.getConfigDir(), "enctl-selected-config.txt");
        try {
            Files.asCharSink(configFile, Charsets.UTF_8, new FileWriteMode[0]).write(selectedClusterId);
        }
        catch (IOException e) {
            throw new EnctlException("Error while writing " + selectedClusterId);
        }
    }

    protected EnctlConfig.Cluster getSelectedClusterConfig() throws EnctlException {
        String selectedClusterId = this.getSelectedClusterId();
        if (selectedClusterId == null || "none".equals(selectedClusterId)) {
            return null;
        }
        return EnctlConfig.Cluster.read(this.getConfigDir(), selectedClusterId);
    }

    protected File getConfigDir() throws EnctlException {
        if (this.customConfigDir != null) {
            if (this.customConfigDir.isFile()) {
                throw new EnctlException("The path specified by --spctl-config-dir must be a directory");
            }
            return this.customConfigDir;
        }
        return DEFAULT_CONFIG_DIR;
    }

    protected void retryOnConcurrencyConflict(RetryableProcedure retryableProcedure) throws EnctlException, InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException, UnexpectedDocumentStructureException {
        int maxRetries = 3;
        int retry = 1;
        while (true) {
            try {
                retryableProcedure.run();
            }
            catch (PreconditionFailedException e) {
                if (++retry <= maxRetries) continue;
                throw new PreconditionFailedException("Could not perform operation due to concurrency conflict. Retried " + maxRetries + " times. Giving up now.", e);
            }
            break;
        }
    }

    @FunctionalInterface
    protected static interface RetryableProcedure {
        public void run() throws EnctlException, InvalidResponseException, FailedConnectionException, ServiceUnavailableException, UnauthorizedException, ApiException, UnexpectedDocumentStructureException;
    }
}

