/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import com.floragunn.encryption.at.rest.lucene.encryption.AtomicBitSet;
import com.floragunn.encryption.at.rest.lucene.encryption.DecryptionStrategy;
import com.floragunn.encryption.at.rest.lucene.encryption.Footer;
import com.floragunn.encryption.at.rest.lucene.encryption.Metrics;
import com.floragunn.encryption.at.rest.lucene.encryption.MultiSegmentBuffer;
import com.floragunn.encryption.at.rest.lucene.encryption.PanamaNativeAccess;
import java.io.EOFException;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.GroupVIntUtil;

abstract class DecryptingMemorySegmentIndexInput
extends IndexInput
implements RandomAccessInput {
    private static final Logger LOG = Logger.getLogger(DecryptingMemorySegmentIndexInput.class.getName());
    static final ValueLayout.OfByte LAYOUT_BYTE = ValueLayout.JAVA_BYTE;
    static final ValueLayout.OfShort LAYOUT_LE_SHORT = ValueLayout.JAVA_SHORT_UNALIGNED.withOrder(ByteOrder.LITTLE_ENDIAN);
    static final ValueLayout.OfInt LAYOUT_LE_INT = ValueLayout.JAVA_INT_UNALIGNED.withOrder(ByteOrder.LITTLE_ENDIAN);
    static final ValueLayout.OfLong LAYOUT_LE_LONG = ValueLayout.JAVA_LONG_UNALIGNED.withOrder(ByteOrder.LITTLE_ENDIAN);
    static final ValueLayout.OfFloat LAYOUT_LE_FLOAT = ValueLayout.JAVA_FLOAT_UNALIGNED.withOrder(ByteOrder.LITTLE_ENDIAN);
    final Path path;
    final long length;
    final long chunkSizeMask;
    final int chunkSizePower;
    final boolean confined;
    final Arena arena;
    final MemorySegment[] segments;
    final AtomicBitSet decryptedChunks;
    final MultiSegmentBuffer multiSegmentBuffer;
    final Footer footer;
    final long decryptionOffset;
    int curSegmentIndex = -1;
    MemorySegment curSegment;
    long curPosition;

    void ensureDecrypted(long len, long offset) throws IOException {
        if (this.multiSegmentBuffer != null && this.footer != null && this.decryptedChunks != null) {
            try {
                this.multiSegmentBuffer.decrypt(len, offset, this.footer, this.decryptedChunks, this.path);
            }
            catch (AlreadyClosedException alreadyClosedException) {
                throw alreadyClosedException;
            }
            catch (EOFException eof) {
                throw eof;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public static DecryptingMemorySegmentIndexInput newInstance(String resourceDescription, Arena arena, MemorySegment[] segments, long length, int chunkSizePower, boolean confined, Path path, Footer footer, DecryptionStrategy decryptionStrategy) {
        assert (Arrays.stream(segments).map(MemorySegment::scope).allMatch(arena.scope()::equals));
        MultiSegmentBuffer multiSegmentBuffer = footer == null ? null : new MultiSegmentBuffer(segments);
        AtomicBitSet decryptedChunks = null;
        if (multiSegmentBuffer != null && decryptionStrategy == DecryptionStrategy.EAGER) {
            try {
                segments = multiSegmentBuffer.decryptAll(footer, path);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (footer != null) {
            decryptedChunks = new AtomicBitSet(footer.getChunkCount());
        }
        if (segments.length == 1) {
            return new SingleSegmentImpl(resourceDescription, arena, segments[0], length, chunkSizePower, confined, path, footer, multiSegmentBuffer, decryptedChunks, 0L);
        }
        return new MultiSegmentImpl(resourceDescription, arena, segments, 0L, length, chunkSizePower, confined, path, footer, multiSegmentBuffer, decryptedChunks, 0L);
    }

    private DecryptingMemorySegmentIndexInput(String resourceDescription, Arena arena, MemorySegment[] segments, long length, int chunkSizePower, boolean confined, Path path, Footer footer, MultiSegmentBuffer multiSegmentBuffer, AtomicBitSet _decryptedChunks, long decryptionOffset) {
        super(resourceDescription);
        this.arena = arena;
        this.segments = segments;
        this.length = length;
        this.chunkSizePower = chunkSizePower;
        this.confined = confined;
        this.chunkSizeMask = (1L << chunkSizePower) - 1L;
        this.curSegment = segments[0];
        this.path = path;
        this.decryptionOffset = decryptionOffset;
        this.multiSegmentBuffer = footer == null ? null : multiSegmentBuffer;
        this.footer = footer;
        this.decryptedChunks = footer == null ? null : _decryptedChunks;
        Metrics.recordInputOpen("mmap", arena == null, decryptionOffset != 0L, path, this.length(), null);
    }

    protected long getDecryptionOffset() {
        return this.getFilePointer() + this.decryptionOffset;
    }

    protected long getDecryptionOffset(long pos) {
        return pos + this.decryptionOffset;
    }

    void ensureOpen() {
        if (this.curSegment == null) {
            throw this.alreadyClosed(null);
        }
    }

    void ensureAccessible() {
        if (this.confined && !this.curSegment.isAccessibleBy(Thread.currentThread())) {
            throw new IllegalStateException("confined");
        }
    }

    RuntimeException handlePositionalIOOBE(RuntimeException unused, String action, long pos) throws IOException {
        if (pos < 0L) {
            return new IllegalArgumentException(action + " negative position (pos=" + pos + "): " + String.valueOf((Object)this));
        }
        throw new EOFException(action + " past EOF (pos=" + pos + "): " + String.valueOf((Object)this));
    }

    AlreadyClosedException alreadyClosed(RuntimeException e) {
        if (this.curSegment == null) {
            return new AlreadyClosedException("Already closed: " + String.valueOf((Object)this));
        }
        if (!Arrays.stream(this.segments).allMatch(s -> s.scope().isAlive())) {
            return new AlreadyClosedException("Already closed: " + String.valueOf((Object)this));
        }
        if (e instanceof IllegalStateException && e.getMessage() != null && e.getMessage().contains("closed")) {
            return new AlreadyClosedException("Already closed: " + String.valueOf((Object)this), (Throwable)e);
        }
        throw e;
    }

    public final byte readByte() throws IOException {
        try {
            this.ensureDecrypted(1L, this.getDecryptionOffset());
            byte v = this.curSegment.get(LAYOUT_BYTE, this.curPosition);
            ++this.curPosition;
            return v;
        }
        catch (IndexOutOfBoundsException e) {
            do {
                ++this.curSegmentIndex;
                if (this.curSegmentIndex >= this.segments.length) {
                    throw new EOFException("read past EOF: " + String.valueOf((Object)this));
                }
                this.curSegment = this.segments[this.curSegmentIndex];
                this.curPosition = 0L;
            } while (this.curSegment.byteSize() == 0L);
            this.ensureDecrypted(1L, this.getDecryptionOffset());
            byte v = this.curSegment.get(LAYOUT_BYTE, this.curPosition);
            ++this.curPosition;
            return v;
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    public final void readBytes(byte[] b, int offset, int len) throws IOException {
        try {
            this.ensureDecrypted(len, this.getDecryptionOffset());
            MemorySegment.copy(this.curSegment, LAYOUT_BYTE, this.curPosition, b, offset, len);
            this.curPosition += (long)len;
        }
        catch (IndexOutOfBoundsException e) {
            this.readBytesBoundary(b, offset, len);
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    private void readBytesBoundary(byte[] b, int offset, int len) throws IOException {
        long startFileOffset = this.getDecryptionOffset();
        int originalLen = len;
        try {
            long fileOffset;
            long curAvail = this.curSegment.byteSize() - this.curPosition;
            while ((long)len > curAvail) {
                fileOffset = startFileOffset + (long)(originalLen - len);
                this.ensureDecrypted(curAvail, fileOffset);
                MemorySegment.copy(this.curSegment, LAYOUT_BYTE, this.curPosition, b, offset, (int)curAvail);
                len = (int)((long)len - curAvail);
                offset = (int)((long)offset + curAvail);
                ++this.curSegmentIndex;
                if (this.curSegmentIndex >= this.segments.length) {
                    throw new EOFException("read past EOF (curSegmentIndex " + this.curSegmentIndex + " > segments.length " + this.segments.length + "): " + String.valueOf((Object)this));
                }
                this.curSegment = this.segments[this.curSegmentIndex];
                this.curPosition = 0L;
                curAvail = this.curSegment.byteSize();
            }
            fileOffset = startFileOffset + (long)(originalLen - len);
            this.ensureDecrypted(len, fileOffset);
            MemorySegment.copy(this.curSegment, LAYOUT_BYTE, this.curPosition, b, offset, len);
            this.curPosition += (long)len;
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    public void readInts(int[] dst, int offset, int length) throws IOException {
        try {
            long totalBytes = 4L * (long)length;
            this.ensureDecrypted(totalBytes, this.getDecryptionOffset());
            MemorySegment.copy(this.curSegment, LAYOUT_LE_INT, this.curPosition, dst, offset, length);
            this.curPosition += 4L * (long)length;
        }
        catch (IndexOutOfBoundsException iobe) {
            super.readInts(dst, offset, length);
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    public void readLongs(long[] dst, int offset, int length) throws IOException {
        try {
            long totalBytes = 8L * (long)length;
            this.ensureDecrypted(totalBytes, this.getDecryptionOffset());
            MemorySegment.copy(this.curSegment, LAYOUT_LE_LONG, this.curPosition, dst, offset, length);
            this.curPosition += 8L * (long)length;
        }
        catch (IndexOutOfBoundsException iobe) {
            super.readLongs(dst, offset, length);
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    public void readFloats(float[] dst, int offset, int length) throws IOException {
        try {
            long totalBytes = 4L * (long)length;
            this.ensureDecrypted(totalBytes, this.getDecryptionOffset());
            MemorySegment.copy(this.curSegment, LAYOUT_LE_FLOAT, this.curPosition, dst, offset, length);
            this.curPosition += 4L * (long)length;
        }
        catch (IndexOutOfBoundsException iobe) {
            super.readFloats(dst, offset, length);
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    public final short readShort() throws IOException {
        try {
            this.ensureDecrypted(2L, this.getDecryptionOffset());
            short v = this.curSegment.get(LAYOUT_LE_SHORT, this.curPosition);
            this.curPosition += 2L;
            return v;
        }
        catch (IndexOutOfBoundsException e) {
            return super.readShort();
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    public final int readInt() throws IOException {
        try {
            this.ensureDecrypted(4L, this.getDecryptionOffset());
            int v = this.curSegment.get(LAYOUT_LE_INT, this.curPosition);
            this.curPosition += 4L;
            return v;
        }
        catch (IndexOutOfBoundsException e) {
            return super.readInt();
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    public final int readVInt() throws IOException {
        return super.readVInt();
    }

    public final long readVLong() throws IOException {
        return super.readVLong();
    }

    public final long readLong() throws IOException {
        try {
            this.ensureDecrypted(8L, this.getDecryptionOffset());
            long v = this.curSegment.get(LAYOUT_LE_LONG, this.curPosition);
            this.curPosition += 8L;
            return v;
        }
        catch (IndexOutOfBoundsException e) {
            return super.readLong();
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    public long getFilePointer() {
        this.ensureOpen();
        return ((long)this.curSegmentIndex << this.chunkSizePower) + this.curPosition;
    }

    public void seek(long pos) throws IOException {
        this.ensureOpen();
        int si = (int)(pos >> this.chunkSizePower);
        try {
            if (si != this.curSegmentIndex) {
                MemorySegment seg = this.segments[si];
                this.curSegmentIndex = si;
                this.curSegment = seg;
            }
            if (this.footer != null && this.getDecryptionOffset(pos) > this.footer.getPlainTextFileSize()) {
                this.handlePositionalIOOBE(null, "seek", pos);
            }
            this.curPosition = Objects.checkIndex(pos & this.chunkSizeMask, this.curSegment.byteSize() + 1L);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.handlePositionalIOOBE(e, "seek", pos);
        }
    }

    public byte readByte(long pos) throws IOException {
        try {
            int si = (int)(pos >> this.chunkSizePower);
            this.ensureDecrypted(1L, this.getDecryptionOffset(pos));
            return this.segments[si].get(LAYOUT_BYTE, pos & this.chunkSizeMask);
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw this.handlePositionalIOOBE(ioobe, "read", pos);
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    protected void readGroupVInt000(long[] dst, int offset) throws IOException {
        try {
            int len = GroupVIntUtil.readGroupVInt((DataInput)this, (long)(this.curSegment.byteSize() - this.curPosition), p -> this.curSegment.get(LAYOUT_LE_INT, p), (long)this.curPosition, (long[])dst, (int)offset);
            this.curPosition += (long)len;
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    private void setPos(long pos, int si) throws IOException {
        try {
            MemorySegment seg = this.segments[si];
            this.curPosition = pos & this.chunkSizeMask;
            this.curSegmentIndex = si;
            this.curSegment = seg;
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw this.handlePositionalIOOBE(ioobe, "read", pos);
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    public short readShort(long pos) throws IOException {
        int si = (int)(pos >> this.chunkSizePower);
        try {
            this.ensureDecrypted(2L, this.getDecryptionOffset(pos));
            return this.segments[si].get(LAYOUT_LE_SHORT, pos & this.chunkSizeMask);
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.setPos(pos, si);
            return this.readShort();
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    public int readInt(long pos) throws IOException {
        int si = (int)(pos >> this.chunkSizePower);
        try {
            this.ensureDecrypted(4L, this.getDecryptionOffset(pos));
            return this.segments[si].get(LAYOUT_LE_INT, pos & this.chunkSizeMask);
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.setPos(pos, si);
            return this.readInt();
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    public long readLong(long pos) throws IOException {
        int si = (int)(pos >> this.chunkSizePower);
        try {
            this.ensureDecrypted(8L, this.getDecryptionOffset(pos));
            return this.segments[si].get(LAYOUT_LE_LONG, pos & this.chunkSizeMask);
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.setPos(pos, si);
            return this.readLong();
        }
        catch (IllegalStateException | NullPointerException e) {
            throw this.alreadyClosed(e);
        }
    }

    public final long length() {
        return this.length;
    }

    public final DecryptingMemorySegmentIndexInput clone() {
        DecryptingMemorySegmentIndexInput clone = this.buildSlice(null, 0L, this.length, 0L);
        try {
            clone.seek(this.getFilePointer());
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
        return clone;
    }

    public final DecryptingMemorySegmentIndexInput slice(String sliceDescription, long offset, long length) {
        if (offset < 0L || length < 0L || offset + length > this.length) {
            throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length + ": " + String.valueOf((Object)this));
        }
        return this.buildSlice(sliceDescription, offset, length, offset);
    }

    DecryptingMemorySegmentIndexInput buildSlice(String sliceDescription, long offset, long length, long originalOffset) {
        this.ensureOpen();
        this.ensureAccessible();
        long sliceAbsoluteOffset = this.decryptionOffset + originalOffset;
        long sliceEnd = offset + length;
        int startIndex = (int)(offset >>> this.chunkSizePower);
        int endIndex = (int)(sliceEnd >>> this.chunkSizePower);
        MemorySegment[] slices = (MemorySegment[])ArrayUtil.copyOfSubArray((Object[])this.segments, (int)startIndex, (int)(endIndex + 1));
        slices[slices.length - 1] = slices[slices.length - 1].asSlice(0L, sliceEnd & this.chunkSizeMask);
        long segmentOffset = offset & this.chunkSizeMask;
        String newResourceDescription = this.getFullSliceDescription(sliceDescription);
        if (slices.length == 1) {
            return new SingleSegmentImpl(newResourceDescription, null, slices[0].asSlice(segmentOffset, length), length, this.chunkSizePower, this.confined, this.path, this.footer, this.multiSegmentBuffer, this.decryptedChunks, sliceAbsoluteOffset);
        }
        return new MultiSegmentImpl(newResourceDescription, null, slices, segmentOffset, length, this.chunkSizePower, this.confined, this.path, this.footer, this.multiSegmentBuffer, this.decryptedChunks, sliceAbsoluteOffset);
    }

    static boolean checkIndex(long index, long length) {
        return index >= 0L && index < length;
    }

    public final void close() throws IOException {
        if (this.curSegment == null) {
            return;
        }
        if (this.arena != null) {
            Throwable t = null;
            for (MemorySegment segment : this.segments) {
                if (segment == null || segment.address() == 0L) continue;
                try {
                    PanamaNativeAccess.madvise(segment.address(), segment.byteSize(), 4);
                }
                catch (Throwable tw) {
                    t = tw;
                }
            }
            if (t != null) {
                LOG.log(Level.WARNING, "madvise MADV_DONTNEED failed on close: " + t.getMessage(), t);
            }
            while (this.arena.scope().isAlive()) {
                try {
                    this.arena.close();
                    break;
                }
                catch (IllegalStateException e) {
                    Thread.onSpinWait();
                }
            }
            if (this.multiSegmentBuffer != null) {
                this.multiSegmentBuffer.close();
            }
        }
        this.curSegment = null;
        Arrays.fill(this.segments, null);
        Metrics.recordInputClose("mmap", this.arena == null, this.path, this.length);
    }

    static final class SingleSegmentImpl
    extends DecryptingMemorySegmentIndexInput {
        SingleSegmentImpl(String resourceDescription, Arena arena, MemorySegment segment, long length, int chunkSizePower, boolean confined, Path path, Footer footer, MultiSegmentBuffer multiSegmentBuffer, AtomicBitSet _decryptedChunks, long decryptionOffset) {
            super(resourceDescription, arena, new MemorySegment[]{segment}, length, chunkSizePower, confined, path, footer, multiSegmentBuffer, _decryptedChunks, decryptionOffset);
            this.curSegmentIndex = 0;
        }

        @Override
        public void seek(long pos) throws IOException {
            this.ensureOpen();
            Metrics.recordSeek("mmap-single-segment", this.path, this.length, pos);
            try {
                this.curPosition = Objects.checkIndex(pos, this.length + 1L);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.handlePositionalIOOBE(e, "seek", pos);
            }
        }

        @Override
        public long getFilePointer() {
            this.ensureOpen();
            return this.curPosition;
        }

        @Override
        public byte readByte(long pos) throws IOException {
            try {
                this.ensureDecrypted(1L, this.getDecryptionOffset(pos));
                return this.curSegment.get(LAYOUT_BYTE, pos);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.handlePositionalIOOBE(e, "read", pos);
            }
            catch (IllegalStateException | NullPointerException e) {
                throw this.alreadyClosed(e);
            }
        }

        @Override
        public short readShort(long pos) throws IOException {
            try {
                this.ensureDecrypted(2L, this.getDecryptionOffset(pos));
                return this.curSegment.get(LAYOUT_LE_SHORT, pos);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.handlePositionalIOOBE(e, "read", pos);
            }
            catch (IllegalStateException | NullPointerException e) {
                throw this.alreadyClosed(e);
            }
        }

        @Override
        public int readInt(long pos) throws IOException {
            try {
                this.ensureDecrypted(4L, this.getDecryptionOffset(pos));
                return this.curSegment.get(LAYOUT_LE_INT, pos);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.handlePositionalIOOBE(e, "read", pos);
            }
            catch (IllegalStateException | NullPointerException e) {
                throw this.alreadyClosed(e);
            }
        }

        @Override
        public long readLong(long pos) throws IOException {
            try {
                this.ensureDecrypted(8L, this.getDecryptionOffset(pos));
                return this.curSegment.get(LAYOUT_LE_LONG, pos);
            }
            catch (IndexOutOfBoundsException e) {
                throw this.handlePositionalIOOBE(e, "read", pos);
            }
            catch (IllegalStateException | NullPointerException e) {
                throw this.alreadyClosed(e);
            }
        }
    }

    static final class MultiSegmentImpl
    extends DecryptingMemorySegmentIndexInput {
        private final long offset;

        MultiSegmentImpl(String resourceDescription, Arena arena, MemorySegment[] segments, long offset, long length, int chunkSizePower, boolean confined, Path path, Footer footer, MultiSegmentBuffer multiSegmentBuffer, AtomicBitSet _decryptedChunks, long decryptionOffset) {
            super(resourceDescription, arena, segments, length, chunkSizePower, confined, path, footer, multiSegmentBuffer, _decryptedChunks, decryptionOffset);
            this.offset = offset;
            try {
                this.seek(0L);
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)ioe);
            }
            assert (this.curSegment != null && this.curSegmentIndex >= 0);
        }

        @Override
        RuntimeException handlePositionalIOOBE(RuntimeException unused, String action, long pos) throws IOException {
            return super.handlePositionalIOOBE(unused, action, pos - this.offset);
        }

        @Override
        public void seek(long pos) throws IOException {
            assert (pos >= 0L) : "negative position";
            Metrics.recordSeek("mmap-multi-segment", this.path, this.length, pos);
            super.seek(pos + this.offset);
        }

        @Override
        public long getFilePointer() {
            return super.getFilePointer() - this.offset;
        }

        @Override
        public byte readByte(long pos) throws IOException {
            return super.readByte(pos + this.offset);
        }

        @Override
        public short readShort(long pos) throws IOException {
            return super.readShort(pos + this.offset);
        }

        @Override
        public int readInt(long pos) throws IOException {
            return super.readInt(pos + this.offset);
        }

        @Override
        public long readLong(long pos) throws IOException {
            return super.readLong(pos + this.offset);
        }

        @Override
        protected long getDecryptionOffset() {
            return super.getDecryptionOffset() - this.offset;
        }

        @Override
        protected long getDecryptionOffset(long pos) {
            return super.getDecryptionOffset(pos) - this.offset;
        }

        @Override
        DecryptingMemorySegmentIndexInput buildSlice(String sliceDescription, long ofs, long length, long originalOffset) {
            return super.buildSlice(sliceDescription, this.offset + ofs, length, originalOffset);
        }
    }
}

