/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import java.nio.ByteBuffer;

public final class Utils {
    private Utils() {
    }

    public static byte[] longToBytesLE(long lng) {
        byte[] bytes = new byte[]{(byte)lng, (byte)(lng >> 8), (byte)(lng >> 16), (byte)(lng >> 24), (byte)(lng >> 32), (byte)(lng >> 40), (byte)(lng >> 48), (byte)(lng >> 56)};
        return bytes;
    }

    public static byte[] longToBytesBE(long lng) {
        byte[] bytes = new byte[]{(byte)(lng >> 56), (byte)(lng >> 48), (byte)(lng >> 40), (byte)(lng >> 32), (byte)(lng >> 24), (byte)(lng >> 16), (byte)(lng >> 8), (byte)lng};
        return bytes;
    }

    public static byte[] longToPaddedBytesBE(long lng, int paddingBytes) {
        byte[] bytes = new byte[8 + paddingBytes];
        bytes[0] = (byte)(lng >> 56);
        bytes[1] = (byte)(lng >> 48);
        bytes[2] = (byte)(lng >> 40);
        bytes[3] = (byte)(lng >> 32);
        bytes[4] = (byte)(lng >> 24);
        bytes[5] = (byte)(lng >> 16);
        bytes[6] = (byte)(lng >> 8);
        bytes[7] = (byte)lng;
        return bytes;
    }

    public static byte[] intToBytesLE(int value) {
        byte[] bytes = new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)};
        return bytes;
    }

    public static byte[] intToBytesBE(int value) {
        byte[] bytes = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return bytes;
    }

    public static int bytesBEToInt(byte[] value) {
        if (value == null || value.length != 4) {
            throw new IllegalArgumentException("Byte array must be exactly 4 bytes");
        }
        return (value[0] & 0xFF) << 24 | (value[1] & 0xFF) << 16 | (value[2] & 0xFF) << 8 | value[3] & 0xFF;
    }

    public static byte[] concat(byte[] ... arrays) {
        if (arrays.length < 2) {
            throw new IllegalArgumentException("At least 2 arrays required");
        }
        if (arrays.length == 2) {
            byte[] first = arrays[0];
            byte[] second = arrays[1];
            byte[] result = new byte[first.length + second.length];
            System.arraycopy(first, 0, result, 0, first.length);
            System.arraycopy(second, 0, result, first.length, second.length);
            return result;
        }
        int totalLength = 0;
        for (byte[] array : arrays) {
            totalLength += array.length;
        }
        byte[] result = new byte[totalLength];
        int currentIndex = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, currentIndex, array.length);
            currentIndex += array.length;
        }
        return result;
    }

    public static ByteBuffer deepClone(ByteBuffer buf) {
        ByteBuffer bufClone = buf.isDirect() ? ByteBuffer.allocateDirect(buf.capacity()) : ByteBuffer.allocate(buf.capacity());
        ByteBuffer bufReadOnly = buf.asReadOnlyBuffer();
        bufReadOnly.rewind();
        bufClone.put(bufReadOnly);
        bufClone.position(buf.position());
        bufClone.limit(buf.limit());
        bufClone.order(buf.order());
        return bufClone;
    }
}

