/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import com.floragunn.encryption.at.rest.lucene.encryption.DirectoryKey;
import com.floragunn.encryption.at.rest.lucene.encryption.EncryptionMode;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

final class KeyWrapUtil {
    private static final ThreadLocal<Cipher> CIPHER_POOL = ThreadLocal.withInitial(() -> {
        try {
            return Cipher.getInstance("AESWrap_256", "SunJCE");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    });

    private KeyWrapUtil() {
    }

    public static byte[] encrypt(EncryptionMode.FileKey fileKey, DirectoryKey directoryKey) throws InvalidKeyException, IllegalBlockSizeException {
        Cipher wrapper = CIPHER_POOL.get();
        wrapper.init(3, directoryKey.asSecretKeySpec());
        return wrapper.wrap(fileKey.asSecretKeySpec());
    }

    public static EncryptionMode.FileKey decrypt(byte[] encryptedFileKey, DirectoryKey directoryKey) throws InvalidKeyException, NoSuchAlgorithmException {
        Cipher wrapper = CIPHER_POOL.get();
        wrapper.init(4, directoryKey.asSecretKeySpec());
        SecretKeySpec fileKey = (SecretKeySpec)wrapper.unwrap(encryptedFileKey, "AES", 3);
        return EncryptionMode.FileKey.fromBytes(fileKey.getEncoded());
    }
}

