/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import com.floragunn.encryption.at.rest.lucene.encryption.DirectoryKey;
import com.floragunn.encryption.at.rest.lucene.encryption.EncryptionMode;
import com.floragunn.encryption.at.rest.lucene.encryption.KeyWrapUtil;
import com.floragunn.encryption.at.rest.lucene.encryption.TagStrategy;
import com.floragunn.encryption.at.rest.lucene.encryption.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;

final class Footer {
    public static final int MIN_SIZE = 104 + CodecUtil.footerLength();
    public static final int LENGTH_INFO_OFFSET = 40 + CodecUtil.footerLength();
    private static final int WRAPPED_KEY_SIZE = 40;
    public static final int MAGIC_BYTES = 79109984;
    private final long plainTextFileSize;
    private final long chunkCount;
    private final int footerLength;
    private final EncryptionMode.FileKey fileKey;
    private final EncryptionMode mode;

    private Footer(long plainTextFileSize, long chunkCount, EncryptionMode.FileKey fileKey, EncryptionMode mode, int footerLength) {
        this.plainTextFileSize = plainTextFileSize;
        this.chunkCount = chunkCount;
        this.fileKey = Objects.requireNonNull(fileKey, "File key must not be null");
        this.mode = Objects.requireNonNull(mode, "Encryption mode must not be null");
        this.footerLength = footerLength;
    }

    public static long plaintextFileSizeOf(Path path) throws IOException {
        try (FileChannel fc = FileChannel.open(Objects.requireNonNull(path, "Path must not be null"), StandardOpenOption.READ);){
            if (fc.size() <= (long)MIN_SIZE) {
                long l = 0L;
                return l;
            }
            ByteBuffer buf = ByteBuffer.allocate(8);
            fc.read(buf, fc.size() - (long)MIN_SIZE);
            long plainTextFileSize = buf.flip().getLong();
            assert (plainTextFileSize >= 0L) : "File size must be positive, got " + plainTextFileSize + " instead";
            assert (plainTextFileSize <= fc.size() - (long)MIN_SIZE) : "File size must not exceed remaining bytes, got " + plainTextFileSize + " instead";
            long l = plainTextFileSize;
            return l;
        }
    }

    public static Footer readFrom(ByteBuffer buffer, DirectoryKey directoryKey) throws IOException {
        Objects.requireNonNull(buffer, "ByteBuffer must not be null");
        Objects.requireNonNull(directoryKey, "Directory key must not be null");
        assert (buffer.order() == ByteOrder.BIG_ENDIAN) : "ByteBuffer needs to be BIG_ENDIAN";
        int footerLength = buffer.getInt(buffer.remaining() - LENGTH_INFO_OFFSET);
        assert (footerLength >= MIN_SIZE) : "Footer length must be at least " + MIN_SIZE + " bytes, got " + footerLength + " instead";
        assert (footerLength <= buffer.remaining()) : "Footer length must not exceed remaining bytes, got " + footerLength + " instead";
        buffer.position(footerLength - MIN_SIZE);
        long plainTextFileSize = buffer.getLong();
        assert (plainTextFileSize >= 0L) : "File size must be positive, got " + plainTextFileSize + " instead";
        long chunkCount = buffer.getLong();
        assert (chunkCount >= 0L) : "Chunk count must be positive, got " + chunkCount + " instead";
        int chunkSize = buffer.getInt();
        assert (chunkSize > 0) : "Chunk size must be positive, got " + chunkSize + " instead";
        byte[] encryptedFileKey = new byte[40];
        buffer.get(encryptedFileKey);
        int modeBytes = buffer.getInt();
        EncryptionMode mode = EncryptionMode.fromModeBytes(modeBytes, chunkSize);
        int storedFooterLength = buffer.getInt();
        assert (storedFooterLength == footerLength) : "Stored footer length must be " + footerLength + ", got " + storedFooterLength + " instead";
        byte[] readMacBytes = new byte[32];
        buffer.get(readMacBytes);
        int footerMagic = buffer.getInt();
        assert (footerMagic == 79109984) : "Footer magic bytes must be 79109984, got " + footerMagic + " instead";
        if (footerMagic != 79109984) {
            throw new IOException("Corrupted footer, expected magic bytes 79109984 but got " + footerMagic + " instead");
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(directoryKey.asSecretKeySpec().getEncoded(), "HmacSHA256");
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA256");
            mac.init(secretKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
        if (mode.getTagStrategy() == TagStrategy.APPEND_TO_END) {
            buffer.position(0);
            for (long l = 0L; l < chunkCount; ++l) {
                byte[] tag = new byte[mode.getTagLength()];
                buffer.get(tag);
                mac.update(tag);
            }
        }
        mac.update(Utils.longToBytesBE(plainTextFileSize));
        mac.update(Utils.longToBytesBE(chunkCount));
        mac.update(Utils.intToBytesBE(chunkSize));
        mac.update(encryptedFileKey);
        mac.update(Utils.intToBytesBE(modeBytes));
        mac.update(Utils.intToBytesBE(footerLength));
        byte[] calculatedMac = mac.doFinal();
        if (!Arrays.equals(readMacBytes, calculatedMac)) {
            throw new IOException("Footer was tampered with");
        }
        try {
            return new Footer(plainTextFileSize, chunkCount, KeyWrapUtil.decrypt(encryptedFileKey, directoryKey), mode, footerLength);
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    public static void writeTo(EncryptionMode mode, EncryptionMode.FileKey fileKey, DirectoryKey directoryKey, IndexOutput delegate, List<BytesRef> tags, long chunkCount, long plainTextFileSize) throws IOException {
        if (fileKey == null) {
            throw new IllegalArgumentException("fileKey must not be null");
        }
        if (directoryKey == null) {
            throw new IllegalArgumentException("directoryKey must not be null");
        }
        assert (mode.getTagStrategy() != TagStrategy.APPEND_TO_END || mode.getTagLength() <= 0 || tags != null) : "tags must not be null when tag strategy = APPEND_TO_END and tag length > 0";
        assert (mode.getTagStrategy() != TagStrategy.APPEND_TO_END || mode.getTagLength() <= 0 || (long)tags.size() == chunkCount) : "tags len must be equals to chunkCount when tag strategy = APPEND_TO_END and tag length > 0";
        int footerLength = 0;
        SecretKeySpec secretKeySpec = new SecretKeySpec(directoryKey.asSecretKeySpec().getEncoded(), "HmacSHA256");
        Mac mac = null;
        try {
            mac = Mac.getInstance("HmacSHA256");
            mac.init(secretKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
        if (tags != null) {
            for (BytesRef br : tags) {
                delegate.writeBytes(br.bytes, br.offset, br.length);
                mac.update(br.bytes, br.offset, br.length);
                footerLength += br.length;
                assert (br.length == mode.getTagLength());
            }
        }
        delegate.writeBytes(Footer.updateHmac(Utils.longToBytesBE(plainTextFileSize), mac), 8);
        footerLength += 8;
        delegate.writeBytes(Footer.updateHmac(Utils.longToBytesBE(chunkCount), mac), 8);
        footerLength += 8;
        delegate.writeBytes(Footer.updateHmac(Utils.intToBytesBE(mode.getChunkSize()), mac), 4);
        footerLength += 4;
        byte[] encryptedFileKey = null;
        try {
            encryptedFileKey = KeyWrapUtil.encrypt(fileKey, directoryKey);
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IOException(e);
        }
        delegate.writeBytes(Footer.updateHmac(encryptedFileKey, encryptedFileKey.length, mac), encryptedFileKey.length);
        footerLength += encryptedFileKey.length;
        assert (encryptedFileKey.length == 40);
        delegate.writeBytes(Footer.updateHmac(Utils.intToBytesBE(mode.getModeBytes()), mac), 4);
        footerLength += 4;
        delegate.writeBytes(Footer.updateHmac(Utils.intToBytesBE(footerLength += 40 + CodecUtil.footerLength()), mac), 4);
        delegate.writeBytes(mac.doFinal(), 32);
        delegate.writeBytes(Utils.intToBytesBE(79109984), 4);
        CodecUtil.writeFooter((IndexOutput)delegate);
    }

    public EncryptionMode.FileKey getFileKey() {
        return this.fileKey;
    }

    public EncryptionMode getMode() {
        return this.mode;
    }

    public long getChunkCount() {
        return this.chunkCount;
    }

    public long getPlainTextFileSize() {
        return this.plainTextFileSize;
    }

    public int getLastChunkSize() {
        return (int)(this.getPlainTextFileSize() - (this.getChunkCount() - 1L) * (long)this.mode.getChunkSize());
    }

    public boolean isLastChunk(long chunk) {
        return chunk == this.getChunkCount() - 1L;
    }

    public Optional<Long> getTagOffsetForChunk(long chunk) {
        if (this.getMode().getTagLength() <= 0 || this.mode.getTagStrategy() == TagStrategy.APPEND_TO_CHUNK) {
            return Optional.empty();
        }
        return Optional.of(this.getPlainTextFileSize() + chunk * (long)this.getMode().getTagLength());
    }

    public int getFooterLength() {
        return this.footerLength;
    }

    public String toString() {
        return "Footer{chunkCount=" + this.chunkCount + ", plainTextFileSize=" + this.plainTextFileSize + ", mode=" + String.valueOf(this.mode) + ", lastChunkSize=" + this.getLastChunkSize() + "}";
    }

    private static byte[] updateHmac(byte[] in, Mac mac) {
        mac.update(in);
        return in;
    }

    private static byte[] updateHmac(byte[] in, int len, Mac mac) {
        mac.update(in, 0, len);
        return in;
    }
}

