/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import com.floragunn.encryption.at.rest.lucene.encryption.CryptoNIOFSDirectory;
import com.floragunn.encryption.at.rest.lucene.encryption.DecryptionStrategy;
import com.floragunn.encryption.at.rest.lucene.encryption.DirectoryKey;
import com.floragunn.encryption.at.rest.lucene.encryption.EncryptionMode;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.ReadAdvice;
import org.apache.lucene.util.Constants;

public final class DecryptingMMapDirectory
extends CryptoNIOFSDirectory {
    private static final Logger LOG = Logger.getLogger(DecryptingMMapDirectory.class.getName());
    public static final BiPredicate<String, IOContext> ALL_FILES = (filename, context) -> true;
    public static final BiPredicate<String, IOContext> NO_FILES = (filename, context) -> false;
    public static final String SHARED_ARENA_MAX_PERMITS_SYSPROP = "org.apache.lucene.store.DecryptingMMapDirectory.sharedArenaMaxPermits";
    public static final Function<String, Optional<String>> NO_GROUPING = filename -> Optional.empty();
    public static final Function<String, Optional<String>> GROUP_BY_SEGMENT = filename -> {
        if (!IndexFileNames.CODEC_FILE_PATTERN.matcher((CharSequence)filename).matches()) {
            return Optional.empty();
        }
        Object groupKey = IndexFileNames.parseSegmentName((String)filename).substring(1);
        try {
            if (IndexFileNames.parseGeneration((String)filename) > 0L) {
                groupKey = (String)groupKey + "-g";
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Optional.of(groupKey);
    };
    public static final BiPredicate<String, IOContext> BASED_ON_LOAD_IO_CONTEXT = (filename, context) -> context.readAdvice() == ReadAdvice.RANDOM_PRELOAD;
    private BiPredicate<String, IOContext> preload = NO_FILES;
    public static final long DEFAULT_MAX_CHUNK_SIZE;
    final Object attachment = PROVIDER.attachment();
    private Function<String, Optional<String>> groupingFunction = GROUP_BY_SEGMENT;
    final int chunkSizePower;
    final DecryptionStrategy decryptionStrategy;
    static final MMapIndexInputProvider<Object> PROVIDER;

    public DecryptingMMapDirectory(Path path, LockFactory lockFactory, Supplier<DirectoryKey> directoryKeySupplier, EncryptionMode mode, DecryptionStrategy decryptionStrategy) throws IOException {
        this(path, lockFactory, DEFAULT_MAX_CHUNK_SIZE, directoryKeySupplier, mode, decryptionStrategy);
    }

    public DecryptingMMapDirectory(Path path, Supplier<DirectoryKey> directoryKeySupplier, EncryptionMode mode, DecryptionStrategy decryptionStrategy) throws IOException {
        this(path, (LockFactory)FSLockFactory.getDefault(), directoryKeySupplier, mode, decryptionStrategy);
    }

    @Deprecated
    public DecryptingMMapDirectory(Path path, int maxChunkSize, Supplier<DirectoryKey> directoryKeySupplier, EncryptionMode mode, DecryptionStrategy decryptionStrategy) throws IOException {
        this(path, (long)maxChunkSize, directoryKeySupplier, mode, decryptionStrategy);
    }

    public DecryptingMMapDirectory(Path path, long maxChunkSize, Supplier<DirectoryKey> directoryKeySupplier, EncryptionMode mode, DecryptionStrategy decryptionStrategy) throws IOException {
        this(path, (LockFactory)FSLockFactory.getDefault(), maxChunkSize, directoryKeySupplier, mode, decryptionStrategy);
    }

    @Deprecated
    public DecryptingMMapDirectory(Path path, LockFactory lockFactory, int maxChunkSize, Supplier<DirectoryKey> directoryKeySupplier, EncryptionMode mode, DecryptionStrategy decryptionStrategy) throws IOException {
        this(path, lockFactory, (long)maxChunkSize, directoryKeySupplier, mode, decryptionStrategy);
    }

    public DecryptingMMapDirectory(Path path, LockFactory lockFactory, long maxChunkSize, Supplier<DirectoryKey> directoryKeySupplier, EncryptionMode mode, DecryptionStrategy decryptionStrategy) throws IOException {
        super(path, lockFactory, directoryKeySupplier, mode);
        if (maxChunkSize <= 0L) {
            throw new IllegalArgumentException("Maximum chunk size for mmap must be >0");
        }
        this.chunkSizePower = 63 - Long.numberOfLeadingZeros(maxChunkSize);
        assert (1L << this.chunkSizePower <= maxChunkSize);
        assert (1L << this.chunkSizePower > maxChunkSize / 2L);
        this.decryptionStrategy = decryptionStrategy;
    }

    public void setPreload(BiPredicate<String, IOContext> preload) {
        this.preload = preload;
    }

    @Deprecated
    public void setPreload(boolean preload) {
        this.preload = preload ? ALL_FILES : NO_FILES;
    }

    @Deprecated
    public boolean getPreload() {
        return this.preload == ALL_FILES;
    }

    public void setGroupingFunction(Function<String, Optional<String>> groupingFunction) {
        this.groupingFunction = groupingFunction;
    }

    public final long getMaxChunkSize() {
        return 1L << this.chunkSizePower;
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        this.ensureCanRead(name);
        Path path = this.directory.resolve(name);
        return PROVIDER.openInput(path, context, this.chunkSizePower, this.preload.test(name, context), this.groupingFunction.apply(name), this.attachment, this.getLazyDirectoryKey(), this.decryptionStrategy);
    }

    private static int getSharedArenaMaxPermitsSysprop() {
        int ret = 1024;
        try {
            String str = System.getProperty(SHARED_ARENA_MAX_PERMITS_SYSPROP);
            if (str != null) {
                ret = Integer.parseInt(str);
            }
        }
        catch (NumberFormatException | SecurityException ignored) {
            Logger.getLogger(DecryptingMMapDirectory.class.getName()).warning("Cannot read sysprop org.apache.lucene.store.DecryptingMMapDirectory.sharedArenaMaxPermits, so the default value will be used.");
        }
        return ret;
    }

    private static <A> MMapIndexInputProvider<A> lookupProvider() {
        int maxPermits = DecryptingMMapDirectory.getSharedArenaMaxPermitsSysprop();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> cls = lookup.findClass("com.floragunn.encryption.at.rest.lucene.encryption.DecryptingMemorySegmentIndexInputProvider");
            MethodHandle constr = lookup.findConstructor(cls, MethodType.methodType(Void.TYPE, Integer.TYPE));
            try {
                return constr.invoke(maxPermits);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable th) {
                throw new AssertionError((Object)th);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new LinkageError("DecryptingMemorySegmentIndexInputProvider is missing correctly typed constructor", e);
        }
        catch (ClassNotFoundException cnfe) {
            throw new LinkageError("DecryptingMemorySegmentIndexInputProvider is missing in Lucene JAR file", cnfe);
        }
    }

    public static boolean supportsMadvise() {
        return PROVIDER.supportsMadvise();
    }

    static {
        PROVIDER = DecryptingMMapDirectory.lookupProvider();
        DEFAULT_MAX_CHUNK_SIZE = PROVIDER.getDefaultMaxChunkSize();
    }

    static interface MMapIndexInputProvider<A> {
        public IndexInput openInput(Path var1, IOContext var2, int var3, boolean var4, Optional<String> var5, A var6, DirectoryKey var7, DecryptionStrategy var8) throws IOException;

        public long getDefaultMaxChunkSize();

        public boolean supportsMadvise();

        default public A attachment() {
            return null;
        }

        default public IOException convertMapFailedIOException(IOException ioe, String resourceDescription, long bufSize) {
            Throwable originalCause;
            String originalMessage;
            if (ioe.getCause() instanceof OutOfMemoryError) {
                originalMessage = "Map failed";
                originalCause = null;
            } else {
                originalMessage = ioe.getMessage();
                originalCause = ioe.getCause();
            }
            String moreInfo = !Constants.JRE_IS_64BIT ? "DecryptingMMapDirectory should only be used on 64bit platforms, because the address space on 32bit operating systems is too small. " : (Constants.WINDOWS ? "Windows is unfortunately very limited on virtual address space. If your index size is several hundred Gigabytes, consider changing to Linux. " : (Constants.LINUX ? "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'), and 'sysctl vm.max_map_count'. " : "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'). "));
            IOException newIoe = new IOException(String.format(Locale.ENGLISH, "%s: %s [this may be caused by lack of enough unfragmented virtual address space or too restrictive virtual memory limits enforced by the operating system, preventing us to map a chunk of %d bytes. %sMore information: https://blog.thetaphi.de/2012/07/use-lucenes-DecryptingMMapDirectory-on-64bit.html]", originalMessage, resourceDescription, bufSize, moreInfo), originalCause);
            newIoe.setStackTrace(ioe.getStackTrace());
            return newIoe;
        }
    }
}

