/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.apache.lucene.store.IOContext;

public final class Metrics {
    private static boolean enabled = false;
    private static Logger logger;
    private static Path metricsFile;
    private static Map<String, MetricDetails> metrics;

    private Metrics() {
    }

    public static void disable() {
        enabled = false;
    }

    static boolean initialize() {
        if (metrics != null) {
            return true;
        }
        if (enabled && metrics == null) {
            logger = Logger.getLogger(Metrics.class.getName());
            metrics = new ConcurrentHashMap<String, MetricDetails>();
            try {
                metricsFile = Files.createTempFile("crypto.metrics", "", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            new Thread(() -> {
                while (true) {
                    try {
                        do {
                            Thread.sleep(60000L);
                            logger.info("Current Metrics for extensions recorded to " + String.valueOf(metricsFile) + " : " + metrics.size());
                        } while (metrics.isEmpty());
                        StringBuilder sb = new StringBuilder();
                        metrics.forEach((ext, details) -> sb.append((String)ext).append("::").append(details.report()).append("\n"));
                        try {
                            Files.writeString(metricsFile, (CharSequence)sb.toString(), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }).start();
            return true;
        }
        logger = null;
        metrics = null;
        return false;
    }

    static void recordInputOpen(String type, boolean clone, boolean slice, Path path, long fileSize, IOContext context) {
        if (Metrics.initialize()) {
            if (Metrics.skip(path)) {
                return;
            }
            metrics.compute(Metrics.getFileExtension(path), (k, v) -> v == null ? new MetricDetails(type, clone, slice, context, fileSize) : v.updateOpen(type, clone, slice, context, fileSize));
        }
    }

    static void recordInputClose(String type, boolean clone, Path path, long fileSize) {
        if (Metrics.initialize()) {
            if (Metrics.skip(path)) {
                return;
            }
            if (!metrics.containsKey(Metrics.getFileExtension(path))) {
                logger.warning("No metrics for closing input file: " + String.valueOf(path));
            } else {
                metrics.compute(Metrics.getFileExtension(path), (k, v) -> v == null ? null : v.updateClose(type, clone, fileSize));
            }
        }
    }

    static void recordSeek(String type, Path path, long fileSize, long pos) {
        if (Metrics.initialize()) {
            if (Metrics.skip(path) || pos == 0L) {
                return;
            }
            if (!metrics.containsKey(Metrics.getFileExtension(path))) {
                logger.warning("No metrics for seek input file: " + String.valueOf(path));
            } else {
                metrics.compute(Metrics.getFileExtension(path), (k, v) -> v == null ? null : v.updateSeek(type, fileSize, pos));
            }
        }
    }

    private static boolean skip(Path path) {
        String fileName = path.getFileName().toString();
        return fileName.endsWith(".si") || fileName.contains("pending_segments_") || fileName.contains("segments_");
    }

    private static String getFileExtension(Path path) {
        String fileName = path.getFileName().toString();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot > 0) {
            return fileName.substring(lastDot + 1);
        }
        return "";
    }

    private static class MetricDetails {
        private final AtomicLong open = new AtomicLong(0L);
        private final AtomicLong cloned = new AtomicLong(0L);
        private final AtomicLong sliced = new AtomicLong(0L);
        private final AtomicLong seek = new AtomicLong(0L);
        private final AtomicLong close = new AtomicLong(0L);

        public MetricDetails(String type, boolean clone, boolean slice, IOContext context, long fileSize) {
            if (!clone && !slice) {
                this.open.incrementAndGet();
            }
            if (clone) {
                this.cloned.incrementAndGet();
            }
            if (slice) {
                this.sliced.incrementAndGet();
            }
        }

        public String report() {
            return "OPENED=" + this.open.get() + ",CLONED=" + this.cloned.get() + ",SLICED=" + this.sliced.get() + ",SEEK=" + this.seek.get() + ",CLOSE=" + this.close.get();
        }

        public MetricDetails updateOpen(String type, boolean clone, boolean slice, IOContext context, long fileSize) {
            if (!clone && !slice) {
                this.open.incrementAndGet();
            }
            if (clone) {
                this.cloned.incrementAndGet();
            }
            if (slice) {
                this.sliced.incrementAndGet();
            }
            return this;
        }

        public MetricDetails updateClose(String type, boolean clone, long fileSize) {
            if (!clone) {
                this.close.incrementAndGet();
            }
            return this;
        }

        public MetricDetails updateSeek(String type, long fileSize, long pos) {
            this.seek.incrementAndGet();
            return this;
        }
    }
}

