/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import com.floragunn.encryption.at.rest.lucene.encryption.DirectoryKey;
import com.floragunn.encryption.at.rest.lucene.encryption.EncryptionMode;
import com.floragunn.encryption.at.rest.lucene.encryption.Footer;
import com.floragunn.encryption.at.rest.lucene.encryption.TagStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;

final class EncryptingIndexOutput
extends IndexOutput {
    private final CRC32 crc = new CRC32();
    private long filePointer = 0L;
    private long chunk;
    private byte[] buffer;
    private int bufferPosition = 0;
    private boolean isClosed = false;
    private final EncryptionMode mode;
    private final EncryptionMode.FileKey fileKey;
    private final DirectoryKey directoryKey;
    private final IndexOutput delegate;
    private List<BytesRef> tags;

    EncryptingIndexOutput(IndexOutput delegate, EncryptionMode mode, DirectoryKey directoryKey) throws IOException {
        super("EncryptingIndexOutput(path=\"" + delegate.getName() + "\")", delegate.getName());
        this.delegate = delegate;
        this.buffer = new byte[mode.getChunkTagSize()];
        this.mode = mode;
        this.directoryKey = directoryKey;
        this.fileKey = EncryptionMode.FileKey.random();
        if (mode.getTagLength() > 0 && mode.getTagStrategy() == TagStrategy.APPEND_TO_END) {
            this.tags = new ArrayList<BytesRef>(1024);
        }
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        int bytesToCopy;
        this.checkClosed();
        if (b == null) {
            throw new NullPointerException("Input buffer cannot be null");
        }
        if (offset < 0 || length < 0 || offset + length > b.length) {
            throw new IndexOutOfBoundsException("Invalid offset or length");
        }
        if (length == 0) {
            return;
        }
        for (int bytesWritten = 0; bytesWritten < length; bytesWritten += bytesToCopy) {
            int remaining = this.mode.getChunkSize() - this.bufferPosition;
            bytesToCopy = Math.min(remaining, length - bytesWritten);
            System.arraycopy(b, offset + bytesWritten, this.buffer, this.bufferPosition, bytesToCopy);
            this.bufferPosition += bytesToCopy;
            if (this.bufferPosition < this.mode.getChunkSize()) continue;
            this.flushBuffer(false);
        }
        this.filePointer += (long)length;
        this.crc.update(b, offset, length);
    }

    public void writeByte(byte b) throws IOException {
        this.checkClosed();
        if (this.bufferPosition >= this.mode.getChunkSize()) {
            this.flushBuffer(false);
        }
        this.buffer[this.bufferPosition++] = b;
        ++this.filePointer;
        this.crc.update(b);
    }

    private void flushBuffer(boolean force) throws IOException {
        if (!force) {
            if (this.bufferPosition >= this.mode.getChunkSize()) {
                this.processAndWrite(this.buffer, this.mode.getChunkSize());
                this.bufferPosition = 0;
            }
        } else if (this.bufferPosition > 0) {
            this.processAndWrite(this.buffer, this.bufferPosition);
            this.bufferPosition = 0;
        }
    }

    private void processAndWrite(byte[] data, int length) throws IOException {
        try {
            assert (length <= this.mode.getChunkSize());
            int written = this.mode.encrypt(this.fileKey, data, 0, length, this.chunk, data, 0);
            assert (length == written - this.mode.getTagLength());
            if (written > 0) {
                this.delegate.writeBytes(data, 0, written - this.mode.getTagLength());
                if (this.tags != null) {
                    this.tags.add(new BytesRef((byte[])data.clone(), written - this.mode.getTagLength(), this.mode.getTagLength()));
                    written -= this.mode.getTagLength();
                }
                if (this.mode.getTagLength() > 0 && this.mode.getTagStrategy() == TagStrategy.APPEND_TO_CHUNK) {
                    this.delegate.writeBytes(data, written - this.mode.getTagLength(), this.mode.getTagLength());
                }
                ++this.chunk;
            }
        }
        catch (Throwable t) {
            throw new IOException("Encryption failed", t);
        }
    }

    public void close() throws IOException {
        IOException exception;
        block10: {
            block9: {
                if (this.isClosed) {
                    return;
                }
                exception = null;
                try {
                    this.flushBuffer(true);
                }
                catch (IOException e) {
                    exception = e;
                }
                try {
                    Footer.writeTo(this.mode, this.fileKey, this.directoryKey, this.delegate, this.tags, this.chunk, this.getFilePointer());
                    if (this.tags != null) {
                        this.tags.clear();
                        this.tags = null;
                    }
                }
                catch (IOException e) {
                    if (exception != null) break block9;
                    exception = e;
                }
            }
            try {
                this.delegate.close();
            }
            catch (IOException e) {
                if (exception != null) break block10;
                exception = e;
            }
        }
        this.buffer = null;
        this.isClosed = true;
        if (exception != null) {
            throw exception;
        }
    }

    public long getFilePointer() {
        return this.filePointer;
    }

    public long getChecksum() throws IOException {
        return this.crc.getValue();
    }

    private void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed");
        }
    }
}

