/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import com.floragunn.encryption.at.rest.lucene.encryption.DecryptingBufferedIndexInput;
import com.floragunn.encryption.at.rest.lucene.encryption.DirectoryKey;
import com.floragunn.encryption.at.rest.lucene.encryption.EncryptingIndexOutput;
import com.floragunn.encryption.at.rest.lucene.encryption.EncryptionMode;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.util.IOUtils;

public class CryptoNIOFSDirectory
extends NIOFSDirectory {
    private static final Logger logger = Logger.getLogger(CryptoNIOFSDirectory.class.getName());
    private final AtomicReference<DirectoryKey> directoryKey = new AtomicReference();
    private final Supplier<DirectoryKey> directoryKeySupplier;
    private final EncryptionMode mode;

    public CryptoNIOFSDirectory(Path path, Supplier<DirectoryKey> directoryKeySupplier, EncryptionMode mode) throws IOException {
        this(path, (LockFactory)FSLockFactory.getDefault(), directoryKeySupplier, mode);
    }

    public CryptoNIOFSDirectory(Path path, LockFactory lockFactory, Supplier<DirectoryKey> directoryKeySupplier, EncryptionMode mode) throws IOException {
        super(path, lockFactory);
        this.directoryKeySupplier = Objects.requireNonNull(directoryKeySupplier, "Directory key supplier must not be null");
        this.mode = Objects.requireNonNull(mode, "Encryption mode must not be null");
    }

    protected final DirectoryKey getLazyDirectoryKey() {
        DirectoryKey key = this.directoryKey.get();
        if (key == null && !this.directoryKey.compareAndSet(null, key = Objects.requireNonNull(this.directoryKeySupplier.get(), "directoryKeySupplier " + String.valueOf(this.directoryKeySupplier.getClass()) + " get() must not return null"))) {
            return this.directoryKey.get();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexInput openInput(String name, IOContext context) throws IOException {
        DecryptingBufferedIndexInput decryptingBufferedIndexInput;
        block5: {
            if (CryptoNIOFSDirectory.isUnencrypted(name)) {
                return super.openInput(name, context);
            }
            this.ensureOpen();
            this.ensureCanRead(name);
            Path path = this.getDirectory().resolve(name);
            if (Files.size(path) == 0L) {
                return super.openInput(name, context);
            }
            FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);
            boolean success = false;
            try {
                DecryptingBufferedIndexInput indexInput = new DecryptingBufferedIndexInput("DecryptingBufferedIndexInput(path=\"" + String.valueOf(path) + "\")", fc, path, context, this.getLazyDirectoryKey());
                success = true;
                decryptingBufferedIndexInput = indexInput;
                if (success) break block5;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{fc});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{fc});
        }
        return decryptingBufferedIndexInput;
    }

    public final IndexOutput createOutput(String name, IOContext context) throws IOException {
        if (CryptoNIOFSDirectory.isUnencrypted(name)) {
            return super.createOutput(name, context);
        }
        return new EncryptingIndexOutput(super.createOutput(name, context), this.mode, this.getLazyDirectoryKey());
    }

    public final IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
        IndexOutput unencryptedOutput = super.createTempOutput(prefix, suffix, context);
        if (CryptoNIOFSDirectory.isUnencrypted(unencryptedOutput.getName())) {
            return unencryptedOutput;
        }
        return new EncryptingIndexOutput(unencryptedOutput, this.mode, this.getLazyDirectoryKey());
    }

    public final EncryptionMode getMode() {
        return this.mode;
    }

    static final boolean isEncrypted(String fileName) {
        return !CryptoNIOFSDirectory.isUnencrypted(fileName);
    }

    static final boolean isUnencrypted(String fileName) {
        boolean unencrypted;
        boolean bl = unencrypted = fileName.endsWith(".si") || fileName.contains("pending_segments_") || fileName.contains("segments_");
        if (unencrypted) {
            // empty if block
        }
        return unencrypted;
    }
}

