/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.action.update_key;

import com.floragunn.encryption.at.rest.action.update_key.UpdateKey;
import com.floragunn.encryption.at.rest.action.update_key.UpdateKeyRequest;
import com.floragunn.encryption.at.rest.action.update_key.UpdateKeyResponse;
import com.floragunn.encryption.at.rest.key_management.ClusterKeK;
import com.floragunn.encryption.at.rest.plugin.KeyStore;
import com.floragunn.encryption.at.rest.support.DataFilesUtil;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.env.Environment;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateKeyAction
extends TransportNodesAction<UpdateKeyRequest, UpdateKeyResponse, NodeKeyUpdateRequest, UpdateKey, Void> {
    protected static Logger logger = LogManager.getLogger(TransportUpdateKeyAction.class);
    private final Environment env;
    private final KeyStore keyStore;

    @Inject
    public TransportUpdateKeyAction(KeyStore keyStore, Environment env, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/searchguard_encryption_at_rest/update_key", clusterService, transportService, actionFilters, NodeKeyUpdateRequest::new, (Executor)threadPool.executor("management"));
        this.keyStore = keyStore;
        this.env = env;
    }

    protected UpdateKey newNodeResponse(StreamInput streamInput, DiscoveryNode discoveryNode) throws IOException {
        return new UpdateKey(streamInput, discoveryNode);
    }

    protected UpdateKeyResponse newResponse(UpdateKeyRequest request, List<UpdateKey> updateKeys, List<FailedNodeException> failures) {
        return new UpdateKeyResponse(this.clusterService.getClusterName(), updateKeys, failures);
    }

    protected NodeKeyUpdateRequest newNodeRequest(UpdateKeyRequest request) {
        return new NodeKeyUpdateRequest(request);
    }

    protected UpdateKey nodeOperation(NodeKeyUpdateRequest request, Task task) {
        try {
            DiscoveryNode masterNode = this.clusterService.state().nodes().getMasterNode();
            DiscoveryNode localNode = this.clusterService.localNode();
            boolean set = this.keyStore.setClusterKeK(request.clusterKeK);
            boolean saved = this.saveSymmetricKey(request.getClusterKeK(), "_encrypted_cluster_key");
            logger.trace("Update cluster key: master {}, set {}, saved {}, node {}/{}", (Object)localNode.equals((Object)masterNode), (Object)set, (Object)saved, (Object)localNode.getName(), (Object)localNode.getId());
            return new UpdateKey(this.clusterService.localNode(), saved, localNode.equals((Object)masterNode), set);
        }
        catch (Exception e) {
            logger.error("Update keys encryption key failed: {}", (Object)e, (Object)e);
            throw new RuntimeException("Update keys encryption key failed", e);
        }
    }

    private boolean saveSymmetricKey(ClusterKeK clusterKeK, String filename) throws Exception {
        Path storeDir = DataFilesUtil.findLocation(this.env, filename);
        Path storedFile = storeDir.resolve(filename);
        if (!Files.exists(storedFile, new LinkOption[0])) {
            Files.write(storedFile, clusterKeK.getRsaEncryptedAndSignedAESKey().bytes(), StandardOpenOption.WRITE, StandardOpenOption.SYNC, StandardOpenOption.DSYNC, StandardOpenOption.CREATE_NEW);
            logger.trace("Store sent cluster key under {} ({})", (Object)storedFile, (Object)this.hashOfFile(storedFile));
            return true;
        }
        logger.trace("Key already exists under {} ({})", (Object)storedFile, (Object)this.hashOfFile(storedFile));
        return false;
    }

    private String hashOfFile(Path file) throws IOException {
        return Hashing.sha256().hashBytes(Files.readAllBytes(file)).toString();
    }

    public static class NodeKeyUpdateRequest
    extends TransportRequest {
        private final ClusterKeK clusterKeK;

        public NodeKeyUpdateRequest(StreamInput in) throws IOException {
            super(in);
            TransportNodesAction.skipLegacyNodesRequestHeader((TransportVersion)TransportVersions.V_8_11_X, (StreamInput)in);
            this.clusterKeK = new ClusterKeK(in);
        }

        public NodeKeyUpdateRequest(UpdateKeyRequest request) {
            this.clusterKeK = request.getKey();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            TransportNodesAction.sendLegacyNodesRequestHeader((TransportVersion)TransportVersions.V_8_11_X, (StreamOutput)out);
            this.clusterKeK.writeTo(out);
        }

        public ClusterKeK getClusterKeK() {
            return this.clusterKeK;
        }
    }
}

