/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import javax.crypto.spec.SecretKeySpec;

public final class DirectoryKey {
    private final byte[] key;

    private DirectoryKey(byte[] key) {
        this.key = key;
    }

    public static DirectoryKey fromBytes(byte[] bytes) {
        if (bytes == null || bytes.length != 32) {
            throw new IllegalArgumentException("Directory key must be 32 bytes long for AES/GCM mode");
        }
        return new DirectoryKey((byte[])bytes.clone());
    }

    SecretKeySpec asSecretKeySpec() {
        return new SecretKeySpec(this.key, "AES");
    }
}

