/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.plugin.validator;

import com.floragunn.encryption.at.rest.plugin.EncryptionAtRestPluginSettings;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;

public class DenyForbiddenApisActionFilter
implements ActionFilter {
    protected Logger logger = LogManager.getLogger(this.getClass());
    private final ClusterService clusterService;

    public DenyForbiddenApisActionFilter(ClusterService clusterService) {
        this.clusterService = Objects.requireNonNull(clusterService, "clusterService is null");
    }

    public int order() {
        return 0;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        if (request instanceof ResizeRequest) {
            ResizeRequest resizeRequest = (ResizeRequest)request;
            this.logger.trace("ResizeRequest {}", (Object)resizeRequest);
            String sourceIndex = IndexNameExpressionResolver.resolveDateMathExpression((String)resizeRequest.getSourceIndex());
            String targetIndex = IndexNameExpressionResolver.resolveDateMathExpression((String)resizeRequest.getTargetIndexRequest().index());
            IndexMetadata sourceIndexMetadata = this.clusterService.state().metadata().index(sourceIndex);
            IndexMetadata targetIndexMetadata = this.clusterService.state().metadata().index(targetIndex);
            this.logger.trace("sourceIndexMetadata {}", (Object)sourceIndexMetadata);
            if (sourceIndexMetadata == null) {
                listener.onFailure((Exception)new IndexNotFoundException(sourceIndex));
                return;
            }
            this.logger.trace("sourceIndexMetadata settings {}", (Object)String.valueOf(sourceIndexMetadata.getSettings()));
            if (EncryptionAtRestPluginSettings.INDEX_ENCRYPTION_ENABLED.getFrom(sourceIndexMetadata.getSettings()).booleanValue()) {
                listener.onFailure((Exception)new ElasticsearchStatusException(action + " is not supported for encrypted indices", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)new IllegalArgumentException("Not supported for encrypted indices."), new Object[0]));
                return;
            }
            if (targetIndexMetadata != null && EncryptionAtRestPluginSettings.INDEX_ENCRYPTION_ENABLED.getFrom(targetIndexMetadata.getSettings()).booleanValue()) {
                listener.onFailure((Exception)new ElasticsearchStatusException(action + " is not supported for encrypted indices", RestStatus.INTERNAL_SERVER_ERROR, (Throwable)new IllegalArgumentException("Not supported for encrypted indices."), new Object[0]));
                return;
            }
        }
        chain.proceed(task, action, request, listener);
    }
}

