/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.plugin;

import com.floragunn.encryption.at.rest.action.initialize_key.TransportInitializeKeyAction;
import com.floragunn.encryption.at.rest.action.update_key.TransportUpdateKeyAction;
import com.floragunn.encryption.at.rest.action.update_key.UpdateKeyAction;
import com.floragunn.encryption.at.rest.action.update_key.UpdateKeyRequest;
import com.floragunn.encryption.at.rest.action.update_key.UpdateKeyResponse;
import com.floragunn.encryption.at.rest.directory.CryptoHybridDirectory;
import com.floragunn.encryption.at.rest.index.CryptoTranslogIndexingOperationListener;
import com.floragunn.encryption.at.rest.lucene.encryption.EncryptionMode;
import com.floragunn.encryption.at.rest.plugin.EncryptionAtRestPluginSettings;
import com.floragunn.encryption.at.rest.plugin.KeyStore;
import com.floragunn.encryption.at.rest.plugin.validator.CreateIndexValidatorActionFilter;
import com.floragunn.encryption.at.rest.plugin.validator.DenyForbiddenApisActionFilter;
import com.floragunn.encryption.at.rest.repo.EncryptedRepositoryFactory;
import com.floragunn.encryption.at.rest.rest.GetEncryptedIndicesApiAction;
import com.floragunn.encryption.at.rest.rest.GetEncryptionAtRestStateApiAction;
import com.floragunn.encryption.at.rest.rest.InitializeKeyApiAction;
import com.floragunn.encryption.at.rest.support.BaseDependencies;
import com.floragunn.encryption.at.rest.support.RSAUtil;
import com.floragunn.encryption.at.rest.support.StaticSettings;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteResponse;
import org.elasticsearch.action.admin.cluster.reroute.TransportClusterRerouteAction;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.MappedActionFilter;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.InternalEngine;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.EnginePlugin;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesMetrics;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class SearchGuardEncryptionAtRestPlugin
extends Plugin
implements IndexStorePlugin,
RepositoryPlugin,
ActionPlugin,
EnginePlugin {
    public static final String ENCRYPTED_TL_FIELD_NAME = "_encrypted_tl_content";
    private final KeyStore keyStore = new KeyStore();
    private final BaseDependencies baseDependencies = new BaseDependencies();
    private final boolean enabled;
    private final Settings settings;
    protected Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private CreateIndexValidatorActionFilter mappedCreateIndexValidatorActionFilter;
    private DenyForbiddenApisActionFilter denyForbiddenApisActionFilter;

    public SearchGuardEncryptionAtRestPlugin(Settings settings, Path configPath) {
        this.settings = settings;
        this.enabled = EncryptionAtRestPluginSettings.ENCRYPTION_AT_REST_ENABLED.getFrom(settings);
        if (this.enabled) {
            this.logger.info("Search Guard Encryption at Rest Plugin enabled");
        } else {
            this.logger.info("Search Guard Encryption at Rest Plugin disabled");
        }
    }

    public Collection<MappedActionFilter> getMappedActionFilters() {
        return List.of((MappedActionFilter)Objects.requireNonNull(this.mappedCreateIndexValidatorActionFilter));
    }

    public Collection<ActionFilter> getActionFilters() {
        return List.of((ActionFilter)Objects.requireNonNull(this.denyForbiddenApisActionFilter));
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        this.mappedCreateIndexValidatorActionFilter = new CreateIndexValidatorActionFilter(this.keyStore);
        this.denyForbiddenApisActionFilter = new DenyForbiddenApisActionFilter(services.clusterService());
        this.baseDependencies.setDependencies(this.settings, services.client(), services.clusterService(), services.threadPool(), services.environment(), services.repositoriesService(), services.indicesService());
        String _publicClusterKey = EncryptionAtRestPluginSettings.NODE_PUBLIC_CLUSTER_KEY.getFrom(this.baseDependencies.getSettings());
        if (_publicClusterKey == null || _publicClusterKey.isEmpty()) {
            throw new RuntimeException("No " + EncryptionAtRestPluginSettings.NODE_PUBLIC_CLUSTER_KEY.name() + " set");
        }
        try {
            this.keyStore.setPublicClusterKey(RSAUtil.parsePublicKey(_publicClusterKey));
        }
        catch (Exception e) {
            this.logger.error("Error setting public key: {}", (Object)e, (Object)e);
            throw new RuntimeException(e);
        }
        this.baseDependencies.getClusterService().addListener(event -> {
            if (!event.localNodeMaster()) {
                return;
            }
            if (event.nodesAdded()) {
                if (this.keyStore.getClusterKeK() == null) {
                    this.logger.trace("MASTER: nodes added but no key yet");
                } else {
                    this.baseDependencies.getLocalClient().execute((ActionType)UpdateKeyAction.INSTANCE, (ActionRequest)new UpdateKeyRequest(this.keyStore.getClusterKeK()), (ActionListener)new ActionListener<UpdateKeyResponse>(){

                        public void onResponse(UpdateKeyResponse updateKeyResponse) {
                            SearchGuardEncryptionAtRestPlugin.this.logger.trace("MASTER: keys updated on all nodes");
                            SearchGuardEncryptionAtRestPlugin.this.baseDependencies.getLocalClient().execute(TransportClusterRerouteAction.TYPE, (ActionRequest)new ClusterRerouteRequest(TimeValue.THIRTY_SECONDS, TimeValue.THIRTY_SECONDS).setRetryFailed(true), (ActionListener)new ActionListener<ClusterRerouteResponse>(){

                                public void onResponse(ClusterRerouteResponse clusterRerouteResponse) {
                                    SearchGuardEncryptionAtRestPlugin.this.logger.trace("reroute by master node {}", (Object)clusterRerouteResponse.getExplanations());
                                }

                                public void onFailure(Exception e) {
                                    SearchGuardEncryptionAtRestPlugin.this.logger.error("Reroute error {}", (Object)e, (Object)e);
                                }
                            });
                        }

                        public void onFailure(Exception e) {
                            SearchGuardEncryptionAtRestPlugin.this.logger.error("Reroute error: {}", (Object)e, (Object)e);
                        }
                    });
                }
            }
        });
        return List.of(this.keyStore);
    }

    public Optional<EngineFactory> getEngineFactory(IndexSettings indexSettings) {
        if (!this.enabled || !EncryptionAtRestPluginSettings.INDEX_ENCRYPTION_ENABLED.getFrom(indexSettings.getSettings()).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of(new EngineFactory(){

            public Engine newReadWriteEngine(EngineConfig config) {
                if (SearchGuardEncryptionAtRestPlugin.this.logger.isTraceEnabled()) {
                    SearchGuardEncryptionAtRestPlugin.this.logger.trace("Intercept engine for " + config.getIndexSettings().getIndex().getName());
                }
                return new InternalEngine(this, config){

                    public Engine.GetResult get(Engine.Get get, MappingLookup mappingLookup, DocumentParser documentParser, Function<Engine.Searcher, Engine.Searcher> searcherWrapper) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("Intercept get request " + get.id());
                        }
                        return super.get(new Engine.Get(false, false, get.id()), mappingLookup, documentParser, searcherWrapper);
                    }

                    public Engine.GetResult getFromTranslog(Engine.Get get, MappingLookup mappingLookup, DocumentParser documentParser, Function<Engine.Searcher, Engine.Searcher> searcherWrapper) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("Intercept getFromTranslog request " + get.id());
                        }
                        return null;
                    }
                };
            }
        });
    }

    public Map<String, IndexStorePlugin.DirectoryFactory> getDirectoryFactories() {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        HashMap<String, IndexStorePlugin.DirectoryFactory> directories = new HashMap<String, IndexStorePlugin.DirectoryFactory>();
        directories.put("encrypted", (indexSettings, shardPath) -> {
            this.logger.debug("Creating new CryptoHybridDirectory for index: {}", (Object)indexSettings.getIndex().getName());
            return new CryptoHybridDirectory(indexSettings, shardPath, () -> this.keyStore.getClusterKeK());
        });
        return directories;
    }

    public List<Setting<?>> getSettings() {
        return StaticSettings.AttributeSet.of(EncryptionAtRestPluginSettings.attributes).toPlatform();
    }

    public Collection<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return List.of(new ActionPlugin.ActionHandler(TransportInitializeKeyAction.TYPE, TransportInitializeKeyAction.class), new ActionPlugin.ActionHandler((ActionType)UpdateKeyAction.INSTANCE, TransportUpdateKeyAction.class));
    }

    public Collection<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        return List.of(new InitializeKeyApiAction(this.baseDependencies.getClusterService(), this.baseDependencies.getThreadPool().getThreadContext()), new GetEncryptedIndicesApiAction(this.baseDependencies.getClusterService()), new GetEncryptionAtRestStateApiAction(this.baseDependencies.getClusterService(), this.keyStore));
    }

    public void onIndexModule(IndexModule indexModule) {
        if (!this.enabled || !EncryptionAtRestPluginSettings.INDEX_ENCRYPTION_ENABLED.getFrom(indexModule.getSettings()).booleanValue()) {
            return;
        }
        if (!"encrypted".equals(IndexModule.INDEX_STORE_TYPE_SETTING.get(indexModule.getSettings()))) {
            throw new RuntimeException("store.type must be set to 'encrypted' for index " + indexModule.getIndex().getName());
        }
        String mode = EncryptionAtRestPluginSettings.INDEX_ENCRYPTION_MODE.getFrom(indexModule.getSettings());
        int chunkSize = EncryptionAtRestPluginSettings.INDEX_ENCRYPTION_CHUNKSIZE.getFrom(indexModule.getSettings());
        switch (mode) {
            case "gcm": {
                EncryptionMode.validateChunkSize((int)chunkSize);
                break;
            }
            case "ctr": {
                EncryptionMode.validateChunkSize((int)chunkSize);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown encryption mode: " + mode + ", must be either 'gcm' or 'ctr'");
            }
        }
        boolean onlyDecrypt = EncryptionAtRestPluginSettings.INDEX_DISABLE_TRANSLOG_ENCRYPTION.getFrom(indexModule.getSettings());
        if (onlyDecrypt) {
            this.logger.trace("Index '{}' is encrypted and we register an decrypting only translog operation listener for it", (Object)indexModule.getIndex().getName());
        } else {
            this.logger.trace("Index '{}' is encrypted and we register an translog operation listener for it", (Object)indexModule.getIndex().getName());
        }
        indexModule.addIndexOperationListener((IndexingOperationListener)new CryptoTranslogIndexingOperationListener(this.keyStore, this.baseDependencies.getIndicesService(), onlyDecrypt));
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, RepositoriesMetrics repositoriesMetrics) {
        if (!this.enabled) {
            return Collections.emptyMap();
        }
        try {
            return Collections.singletonMap("encrypted", new EncryptedRepositoryFactory(bigArrays, namedXContentRegistry, clusterService, recoverySettings, this.keyStore, this.baseDependencies));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

