/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.key_management;

import com.floragunn.encryption.at.rest.support.ArrayUtil;
import java.util.Arrays;
import java.util.Objects;

public class RSAEncryptedAndSignedAESKey {
    private final byte[] encryptedAndSignedAesKey;

    public RSAEncryptedAndSignedAESKey(byte[] encryptedAndSignedAesKey) {
        Objects.requireNonNull(encryptedAndSignedAesKey, ".encryptedAndSignedAesKey must not be null");
        if (encryptedAndSignedAesKey.length != 512 && encryptedAndSignedAesKey.length != 1024) {
            throw new IllegalArgumentException("encryptedAndSignedAesKey must be 512 or 1024 bytes long");
        }
        if (ArrayUtil.isAllZeros(encryptedAndSignedAesKey)) {
            throw new IllegalArgumentException("encryptedAndSignedAesKey must not be all zeros");
        }
        this.encryptedAndSignedAesKey = (byte[])encryptedAndSignedAesKey.clone();
    }

    public byte[] bytes() {
        return (byte[])this.encryptedAndSignedAesKey.clone();
    }

    public byte[] encryptedKeyBytes() {
        return Arrays.copyOf(this.encryptedAndSignedAesKey, this.encryptedAndSignedAesKey.length / 2);
    }

    public byte[] signatureBytes() {
        return Arrays.copyOfRange(this.encryptedAndSignedAesKey, this.encryptedAndSignedAesKey.length / 2, this.encryptedAndSignedAesKey.length);
    }
}

