/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.rest;

import com.floragunn.encryption.at.rest.plugin.EncryptionAtRestPluginSettings;
import com.floragunn.encryption.at.rest.plugin.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetEncryptionAtRestStateApiAction
extends BaseRestHandler {
    private final ClusterService clusterService;
    private final KeyStore keyStore;

    public GetEncryptionAtRestStateApiAction(ClusterService clusterService, KeyStore keyStore) {
        this.clusterService = clusterService;
        this.keyStore = Objects.requireNonNull(keyStore, "KeyStore must not be null");
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_encryption_at_rest/api/_state"));
    }

    public String getName() {
        return "Get Search Guard Encryption at Rest State Action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        return channel -> {
            RestResponse response = null;
            try (XContentBuilder builder = channel.newBuilder();){
                Metadata clusterMetadata = this.clusterService.state().metadata();
                ArrayList encryptedIndices = new ArrayList();
                Arrays.stream(clusterMetadata.getConcreteAllIndices()).forEach(index -> {
                    IndexMetadata indexMetadata = clusterMetadata.index(index);
                    if (EncryptionAtRestPluginSettings.INDEX_ENCRYPTION_ENABLED.getFrom(indexMetadata.getSettings()).booleanValue()) {
                        encryptedIndices.add(clusterMetadata.index(index));
                    }
                });
                builder.startObject();
                builder.field("is_public_key_set", this.keyStore.isPublicClusterKeySet());
                builder.field("is_cluster_key_set", this.keyStore.isClusterKeySet());
                builder.field("number_of_encrypted_indices", encryptedIndices.size());
                builder.endObject();
                response = new RestResponse(RestStatus.OK, builder);
            }
            channel.sendResponse(response);
        };
    }
}

