/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.rest;

import com.floragunn.encryption.at.rest.plugin.EncryptionAtRestPluginSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetEncryptedIndicesApiAction
extends BaseRestHandler {
    private final ClusterService clusterService;

    public GetEncryptedIndicesApiAction(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_encryption_at_rest/api/_get_encrypted_indices"));
    }

    public String getName() {
        return "Get Encrypted Indices Action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return channel -> {
            RestResponse response = null;
            try (XContentBuilder builder = channel.newBuilder();){
                ProjectMetadata projectMetadata = this.clusterService.state().metadata().getProject();
                ArrayList encryptedIndices = new ArrayList();
                Arrays.stream(projectMetadata.getConcreteAllIndices()).forEach(index -> {
                    IndexMetadata indexMetadata = projectMetadata.index(index);
                    if (EncryptionAtRestPluginSettings.INDEX_ENCRYPTION_ENABLED.getFrom(indexMetadata.getSettings()).booleanValue()) {
                        encryptedIndices.add(projectMetadata.index(index));
                    }
                });
                builder.startObject();
                for (IndexMetadata indexMetadata : encryptedIndices) {
                    builder.startObject(indexMetadata.getIndexUUID());
                    builder.field("name", indexMetadata.getIndex().getName());
                    builder.field(EncryptionAtRestPluginSettings.INDEX_DISABLE_TRANSLOG_ENCRYPTION.name(), EncryptionAtRestPluginSettings.INDEX_DISABLE_TRANSLOG_ENCRYPTION.getFrom(indexMetadata.getSettings()));
                    builder.field(EncryptionAtRestPluginSettings.INDEX_ALLOW_MMAP.name(), EncryptionAtRestPluginSettings.INDEX_ALLOW_MMAP.getFrom(indexMetadata.getSettings()));
                    builder.endObject();
                }
                builder.endObject();
                response = new RestResponse(RestStatus.OK, builder);
            }
            channel.sendResponse(response);
        };
    }
}

