/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import com.floragunn.encryption.at.rest.lucene.encryption.AtomicBitSet;
import com.floragunn.encryption.at.rest.lucene.encryption.Footer;
import java.io.EOFException;
import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.store.AlreadyClosedException;

final class MultiSegmentBuffer {
    private final MemorySegment[] segments;
    private final long[] cumulative;
    private final long totalSize;
    private volatile boolean closed = false;
    private final Object lock = new Object();
    private volatile ByteBuffer cipherTextBuffer;

    MultiSegmentBuffer(MemorySegment[] segments) {
        Objects.requireNonNull(segments, "segments");
        this.segments = (MemorySegment[])segments.clone();
        this.cumulative = new long[this.segments.length + 1];
        long size = 0L;
        for (int i = 0; i < this.segments.length; ++i) {
            Objects.requireNonNull(this.segments[i], "segment[" + i + "] is null");
            this.cumulative[i + 1] = size += this.segments[i].byteSize();
        }
        this.totalSize = size;
    }

    long size() {
        return this.totalSize;
    }

    int read(long offset, ByteBuffer dst) {
        int segIdx;
        Objects.requireNonNull(dst, "dst");
        int requested = dst.remaining();
        if (requested == 0) {
            return 0;
        }
        this.checkOffset(offset);
        int copied = 0;
        long inSegOffset = offset - this.cumulative[segIdx];
        for (segIdx = this.findSegmentIndex(offset); segIdx < this.segments.length && dst.hasRemaining(); ++segIdx) {
            MemorySegment seg = this.segments[segIdx];
            long segRemaining = seg.byteSize() - inSegOffset;
            int toCopy = (int)Math.min((long)dst.remaining(), segRemaining);
            ByteBuffer segView = seg.asSlice(inSegOffset, toCopy).asByteBuffer();
            dst.put(segView);
            copied += toCopy;
            inSegOffset = 0L;
        }
        return copied;
    }

    int write(long offset, ByteBuffer src) {
        int segIdx;
        Objects.requireNonNull(src, "src");
        int requested = src.remaining();
        if (requested == 0) {
            return 0;
        }
        this.checkOffset(offset);
        int copied = 0;
        long inSegOffset = offset - this.cumulative[segIdx];
        for (segIdx = this.findSegmentIndex(offset); segIdx < this.segments.length && src.hasRemaining(); ++segIdx) {
            MemorySegment seg = this.segments[segIdx];
            long segRemaining = seg.byteSize() - inSegOffset;
            int toCopy = (int)Math.min((long)src.remaining(), segRemaining);
            ByteBuffer segView = seg.asSlice(inSegOffset, toCopy).asByteBuffer();
            ByteBuffer tmp = src.duplicate();
            tmp.limit(tmp.position() + toCopy);
            segView.put(tmp);
            src.position(src.position() + toCopy);
            copied += toCopy;
            inSegOffset = 0L;
        }
        return copied;
    }

    private void checkOffset(long offset) {
        if (offset < 0L || offset >= this.totalSize) {
            new Exception().printStackTrace();
            throw new IllegalArgumentException("Offset " + offset + " out of bounds (size=" + this.totalSize + ")");
        }
    }

    private int findSegmentIndex(long offset) {
        int idx = Arrays.binarySearch(this.cumulative, offset);
        if (idx >= 0) {
            return idx;
        }
        return -idx - 2;
    }

    MemorySegment[] decryptAll(Footer footer, Path path) throws Exception {
        this.decrypt(footer.getPlainTextFileSize(), 0L, footer, null, path);
        long excessBytes = Files.size(path) - footer.getPlainTextFileSize();
        if (excessBytes > 0L) {
            long bytesRemoved = 0L;
            for (int segNr = this.segments.length - 1; segNr >= 0; --segNr) {
                MemorySegment segment = this.segments[segNr];
                if (segment == null) continue;
                if (segment.byteSize() >= excessBytes - bytesRemoved) {
                    long newSize = segment.byteSize() - excessBytes + bytesRemoved;
                    this.segments[segNr] = segment.reinterpret(newSize);
                    break;
                }
                bytesRemoved += segment.byteSize();
                this.segments[segNr].unload();
                this.segments[segNr] = null;
            }
        }
        return (MemorySegment[])Arrays.stream(this.segments).filter(Objects::nonNull).toArray(MemorySegment[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrypt(long len, long offset, Footer footer, AtomicBitSet decryptedChunks, Path path) throws Exception {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset < 0 (" + offset + ")");
        }
        if (len < 0L) {
            throw new IllegalArgumentException("len < 0 (" + len + ")");
        }
        if (len == 0L) {
            return;
        }
        if (offset + len > footer.getPlainTextFileSize()) {
            throw new EOFException("pos=" + (offset + len) + " > filelength=" + footer.getPlainTextFileSize());
        }
        long startChunk = offset / (long)footer.getMode().getChunkSize();
        long endChunk = (offset + len - 1L) / (long)footer.getMode().getChunkSize();
        if (startChunk < 0L || startChunk >= footer.getChunkCount()) {
            throw new IllegalArgumentException("start chunk out of bounds: chunk=" + startChunk + ",chunkCount=" + footer.getChunkCount() + ": " + String.valueOf(this));
        }
        if (endChunk >= footer.getChunkCount()) {
            throw new EOFException("endChunk: " + endChunk + " >= chunkcount: " + footer.getChunkCount());
        }
        if (!footer.isLastChunk(endChunk)) {
            ++endChunk;
        }
        for (long chunk = startChunk; chunk <= endChunk; ++chunk) {
            if (decryptedChunks != null && decryptedChunks.get(chunk)) continue;
            Object object = this.lock;
            synchronized (object) {
                if (decryptedChunks != null && decryptedChunks.get(chunk)) {
                    continue;
                }
                if (this.cipherTextBuffer == null) {
                    this.cipherTextBuffer = ByteBuffer.allocate(footer.getMode().getChunkTagSize());
                }
                this.cipherTextBuffer.clear();
                int chunkSize = footer.isLastChunk(chunk) ? footer.getLastChunkSize() : footer.getMode().getChunkSize();
                this.cipherTextBuffer.limit(chunkSize);
                if (this.closed) {
                    throw new AlreadyClosedException("This buffer has been closed");
                }
                try {
                    int read = this.read(chunk * (long)footer.getMode().getChunkSize(), this.cipherTextBuffer);
                    assert (read == chunkSize) : read + " != " + chunkSize;
                    this.cipherTextBuffer.limit(this.cipherTextBuffer.position() + footer.getMode().getTagLength());
                    Optional<Long> tagPos = footer.getTagOffsetForChunk(chunk);
                    if (tagPos.isPresent()) {
                        int tagBytesRead = this.read(tagPos.get(), this.cipherTextBuffer);
                        assert (tagBytesRead == footer.getMode().getTagLength());
                    }
                    this.cipherTextBuffer.flip();
                    ByteBuffer out = this.cipherTextBuffer.duplicate();
                    footer.getMode().decrypt(footer.getFileKey(), this.cipherTextBuffer, out, chunk);
                    out.flip();
                    this.write(chunk * (long)footer.getMode().getChunkSize(), out);
                    out.clear();
                }
                catch (IllegalStateException e) {
                    throw new AlreadyClosedException("This buffer has been closed", (Throwable)e);
                }
                if (decryptedChunks != null) {
                    decryptedChunks.getAndSet(chunk);
                }
                continue;
            }
        }
    }

    public void close() {
        this.closed = true;
    }
}

