/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.support;

import com.floragunn.encryption.at.rest.key_management.AESKey;
import com.floragunn.encryption.at.rest.key_management.RSAEncryptedAndSignedAESKey;
import com.floragunn.encryption.at.rest.support.ArrayUtil;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.Cipher;

public class RSAUtil {
    public static PublicKey parsePublicKey(String publicKey) throws Exception {
        byte[] key = Base64.getDecoder().decode(publicKey);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(key);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(spec);
    }

    public static PrivateKey parsePrivateKey(byte[] privateKey) throws Exception {
        return RSAUtil.parsePrivateKey0(Base64.getDecoder().decode(privateKey));
    }

    private static PrivateKey parsePrivateKey0(byte[] privateKeyRaw) throws Exception {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(privateKeyRaw);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(spec);
    }

    public static AESKey decryptKey(RSAEncryptedAndSignedAESKey rsaEncryptedAndSignedAESKey, KeyPair keyPair) throws Exception {
        Objects.requireNonNull(rsaEncryptedAndSignedAESKey, "rsaEncryptedAndSignedAESKey must not be null");
        Objects.requireNonNull(keyPair, "Key pair must not be null");
        Cipher encryptCipher = Cipher.getInstance("RSA");
        encryptCipher.init(2, keyPair.getPrivate());
        byte[] decryptedKey = encryptCipher.doFinal(rsaEncryptedAndSignedAESKey.encryptedKeyBytes());
        Signature verifier = Signature.getInstance("SHA256withRSA");
        verifier.initVerify(keyPair.getPublic());
        verifier.update(decryptedKey);
        if (!verifier.verify(rsaEncryptedAndSignedAESKey.signatureBytes())) {
            throw new GeneralSecurityException("Signature verification failed");
        }
        return new AESKey(decryptedKey);
    }

    public static RSAEncryptedAndSignedAESKey encryptKey(AESKey aesKey, KeyPair keyPair) throws Exception {
        Objects.requireNonNull(aesKey, "Plain text key must not be null");
        Objects.requireNonNull(keyPair, "Key pair must not be null");
        Signature signer = Signature.getInstance("SHA256withRSA");
        signer.initSign(keyPair.getPrivate());
        signer.update(aesKey.bytes());
        byte[] signature = signer.sign();
        Cipher encryptCipher = Cipher.getInstance("RSA");
        encryptCipher.init(1, keyPair.getPublic());
        return new RSAEncryptedAndSignedAESKey(ArrayUtil.concatArrays(encryptCipher.doFinal(aesKey.bytes()), signature, new byte[0][]));
    }
}

