/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.key_management;

import com.floragunn.encryption.at.rest.key_management.AESKey;
import com.floragunn.encryption.at.rest.key_management.WrappedAESKey;
import com.floragunn.encryption.at.rest.lucene.encryption.Utils;
import com.floragunn.encryption.at.rest.support.ArrayUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.GCMModeCipher;
import org.bouncycastle.crypto.modes.GCMSIVBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.elasticsearch.common.bytes.BytesReference;

public class WrappedAESKeyContainer {
    private final AESKey aesKey;
    private final WrappedAESKey wrappedAESKey;

    public WrappedAESKeyContainer(AESKey aesKey, WrappedAESKey wrappedAESKey) {
        this.aesKey = Objects.requireNonNull(aesKey, "aesKey must not be null");
        this.wrappedAESKey = Objects.requireNonNull(wrappedAESKey, "wrappedAESKey must not be null");
    }

    public WrappedAESKey wrappedAESKey() {
        return this.wrappedAESKey;
    }

    public AESKey aesKey() {
        return this.aesKey;
    }

    public byte[] encryptWithSiv(BytesReference plainTextBytes, byte[] aad) throws Exception {
        Objects.requireNonNull(plainTextBytes, "plainTextBytes must not be null");
        GCMSIVBlockCipher gcmsivBlockCipher = AESKey.GCM_SIV_CIPHER_POOL.get();
        gcmsivBlockCipher.init(true, (CipherParameters)new AEADParameters(new KeyParameter(this.aesKey.bytes()), 128, AESKey.EMPTY_NONCE, aad));
        CipherInputStream in = new CipherInputStream((InputStream)plainTextBytes.streamInput(), (AEADBlockCipher)gcmsivBlockCipher);
        return ArrayUtil.concatArrays(this.wrappedAESKey.bytes(), in.readAllBytes(), new byte[0][]);
    }

    public InputStream encryptingIn(InputStream in) {
        GCMModeCipher gcmBlockCipher = AESKey.GCM_CIPHER_POOL.get();
        byte[] nonce = new byte[12];
        AESKey.SECURE_RANDOM.nextBytes(nonce);
        gcmBlockCipher.init(true, (CipherParameters)new AEADParameters(new KeyParameter(this.aesKey.bytes()), 128, nonce, null));
        List<InputStream> streams = Arrays.asList(new ByteArrayInputStream(Utils.intToBytesBE((int)-281901)), new ByteArrayInputStream(this.wrappedAESKey.bytes()), new ByteArrayInputStream(nonce), new CipherInputStream(in, (AEADBlockCipher)gcmBlockCipher));
        return new SequenceInputStream(Collections.enumeration(streams));
    }

    public OutputStream encryptingOut(OutputStream out) throws IOException {
        GCMModeCipher gcmBlockCipher = AESKey.GCM_CIPHER_POOL.get();
        byte[] nonce = new byte[12];
        AESKey.SECURE_RANDOM.nextBytes(nonce);
        gcmBlockCipher.init(true, (CipherParameters)new AEADParameters(new KeyParameter(this.aesKey.bytes()), 128, nonce, null));
        out.write(Utils.intToBytesBE((int)-281901));
        out.write(this.wrappedAESKey.bytes());
        out.write(nonce);
        return new CipherOutputStream(out, (AEADBlockCipher)gcmBlockCipher);
    }
}

