/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.support;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;

public class KeyPairValidator {
    public static boolean areKeyPairMatch(PrivateKey privateKey, PublicKey publicKey) throws GeneralSecurityException {
        if (privateKey == null || publicKey == null) {
            throw new IllegalArgumentException("Keys cannot be null");
        }
        if (!privateKey.getAlgorithm().equals(publicKey.getAlgorithm())) {
            return false;
        }
        try {
            byte[] testData = "Test data for key pair validation".getBytes();
            String signatureAlgorithm = KeyPairValidator.getSignatureAlgorithm(privateKey);
            Signature signer = Signature.getInstance(signatureAlgorithm);
            signer.initSign(privateKey);
            signer.update(testData);
            byte[] signature = signer.sign();
            Signature verifier = Signature.getInstance(signatureAlgorithm);
            verifier.initVerify(publicKey);
            verifier.update(testData);
            return verifier.verify(signature);
        }
        catch (InvalidKeyException e) {
            return false;
        }
    }

    private static String getSignatureAlgorithm(PrivateKey privateKey) throws NoSuchAlgorithmException {
        switch (privateKey.getAlgorithm()) {
            case "RSA": {
                return "SHA256withRSA";
            }
            case "DSA": {
                return "SHA256withDSA";
            }
            case "EC": {
                return "SHA256withECDSA";
            }
        }
        throw new NoSuchAlgorithmException("Unsupported key algorithm: " + privateKey.getAlgorithm());
    }
}

