/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.config.text;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.config.text.PatternImpl;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.google.common.collect.HashMultimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class PatternMap<V> {
    private final ImmutableMap<String, ImmutableSet<V>> constants;
    private final ImmutableMap<Pattern, ImmutableSet<V>> patterns;
    private final Node<V> trieRoot;

    private PatternMap(ImmutableMap<String, ImmutableSet<V>> constants, ImmutableMap<Pattern, ImmutableSet<V>> patterns, Node<V> trieRoot) {
        this.constants = constants;
        this.patterns = patterns;
        this.trieRoot = trieRoot;
    }

    public ImmutableSet<V> get(String key) {
        ImmutableSet result = (ImmutableSet)this.constants.get((Object)key);
        if (result == null) {
            result = ImmutableSet.empty();
        }
        if (this.patterns.isEmpty() && ((Node)this.trieRoot).size == 0) {
            return result;
        }
        if (((Node)this.trieRoot).size != 0) {
            ImmutableSet.Builder resultBuilder = new ImmutableSet.Builder((Collection)result);
            this.trieRoot.get(key, 0, resultBuilder);
            for (Map.Entry entry : this.patterns.entrySet()) {
                Pattern pattern = (Pattern)entry.getKey();
                if (!pattern.matches(key)) continue;
                resultBuilder.addAll((Collection)entry.getValue());
            }
            return resultBuilder.build();
        }
        ImmutableSet.Builder resultBuilder = null;
        for (Map.Entry entry : this.patterns.entrySet()) {
            Pattern pattern = (Pattern)entry.getKey();
            if (!pattern.matches(key)) continue;
            if (resultBuilder == null) {
                if (result.isEmpty()) {
                    result = (ImmutableSet)entry.getValue();
                    continue;
                }
                resultBuilder = new ImmutableSet.Builder((Collection)result).with((Collection)entry.getValue());
                continue;
            }
            resultBuilder.addAll((Collection)entry.getValue());
        }
        if (resultBuilder != null) {
            return resultBuilder.build();
        }
        return result;
    }

    public ImmutableSet<V> get(Collection<String> keys) {
        ImmutableSet.Builder resultBuilder = new ImmutableSet.Builder();
        for (String key : keys) {
            ImmutableSet value = (ImmutableSet)this.constants.get((Object)key);
            if (value != null) {
                resultBuilder.addAll((Collection)value);
            }
            if (((Node)this.trieRoot).size != 0) {
                this.trieRoot.get(key, 0, resultBuilder);
            }
            for (Map.Entry entry : this.patterns.entrySet()) {
                Pattern pattern = (Pattern)entry.getKey();
                if (!pattern.matches(key)) continue;
                resultBuilder.addAll((Collection)entry.getValue());
            }
        }
        return resultBuilder.build();
    }

    public boolean isEmpty() {
        return this.constants.isEmpty() && this.patterns.isEmpty();
    }

    static class Node<V> {
        private final char[] nextKeys;
        private final Node<V>[] nextNodes;
        private final ImmutableMap<PatternImpl, ImmutableSet<V>> patterns;
        private final int size;

        Node(char[] nextKeys, Node<V>[] nextNodes, ImmutableMap<PatternImpl, ImmutableSet<V>> patterns, int size) {
            this.nextKeys = nextKeys;
            this.nextNodes = nextNodes;
            this.patterns = patterns;
            this.size = size;
        }

        void get(String value, int offset, ImmutableSet.Builder<V> result) {
            int pos;
            if (!this.patterns.isEmpty()) {
                this.patterns.forEach((pattern, v) -> {
                    if (pattern.matchesSkipPrefix(value)) {
                        result.addAll((Collection)v);
                    }
                });
            }
            if (offset >= value.length()) {
                return;
            }
            char c = value.charAt(offset);
            if (this.nextKeys.length == 1) {
                if (this.nextKeys[0] == c) {
                    this.nextNodes[0].get(value, offset + 1, result);
                }
            } else if (this.nextKeys.length != 0 && (pos = Arrays.binarySearch(this.nextKeys, c)) >= 0) {
                this.nextNodes[pos].get(value, offset + 1, result);
            }
        }

        static class Builder<V> {
            private TreeMap<Character, Builder<V>> nodes = new TreeMap();
            private HashMultimap<PatternImpl, V> patterns = HashMultimap.create();
            private int size = 0;

            Builder(String prefix) {
            }

            void add(String key, int pos, PatternImpl pattern, V value) {
                ++this.size;
                if (key == null) {
                    this.patterns.put((Object)pattern, value);
                    return;
                }
                char c = key.charAt(pos);
                Builder childNode = this.nodes.computeIfAbsent(Character.valueOf(c), c0 -> new Builder(key.substring(0, pos + 1)));
                if (pos == key.length() - 1) {
                    childNode.patterns.put((Object)pattern, value);
                } else {
                    childNode.add(key, pos + 1, pattern, value);
                }
            }

            Node<V> build() {
                char[] nextKeys = new char[this.nodes.size()];
                Node[] nextNodes = new Node[this.nodes.size()];
                int i = 0;
                for (Map.Entry<Character, Builder<V>> entry : this.nodes.entrySet()) {
                    nextKeys[i] = entry.getKey().charValue();
                    nextNodes[i] = entry.getValue().build();
                    ++i;
                }
                return new Node(nextKeys, nextNodes, ImmutableMap.map((Map)this.patterns.asMap(), k -> k, v -> ImmutableSet.of((Collection)v)), this.size);
            }
        }
    }

    public static class Builder<V> {
        private HashMultimap<String, V> constants = HashMultimap.create();
        private HashMultimap<Pattern, V> patternsWithoutPrefix = HashMultimap.create();
        private HashMultimap<Pattern, V> patternsWithPrefix = HashMultimap.create();
        private Node.Builder<V> trieRoot = new Node.Builder("");

        public void add(Pattern pattern, V value) {
            if (pattern instanceof PatternImpl.Constant) {
                this.constants.put((Object)((PatternImpl.Constant)pattern).getValue(), value);
            } else if (pattern instanceof PatternImpl.CompoundPattern) {
                for (String constant : ((PatternImpl.CompoundPattern)pattern).getConstants()) {
                    this.constants.put((Object)constant, value);
                }
                for (Pattern subPattern : ((PatternImpl.CompoundPattern)pattern).getPatternObjects()) {
                    this.add(subPattern, value);
                }
            } else if (pattern instanceof PatternImpl) {
                String prefix = ((PatternImpl)pattern).getPrefix();
                if (prefix != null) {
                    this.trieRoot.add(prefix, 0, (PatternImpl)pattern, value);
                    this.patternsWithPrefix.put((Object)pattern, value);
                } else {
                    this.patternsWithoutPrefix.put((Object)pattern, value);
                }
            } else {
                this.patternsWithoutPrefix.put((Object)pattern, value);
            }
        }

        public PatternMap<V> build() {
            return new PatternMap(ImmutableMap.map((Map)this.constants.asMap(), k -> k, v -> ImmutableSet.of((Collection)v)), ImmutableMap.map((Map)this.patternsWithoutPrefix.asMap(), k -> k, v -> ImmutableSet.of((Collection)v)), this.trieRoot.build());
        }
    }
}

