/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents;

import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.DocumentParseException;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingException;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class BasicJsonPathDefaultConfiguration
implements Configuration.Defaults {
    public static final JsonProvider JSON_PROVIDER = new AbstractJsonProvider(){

        public String toJson(Object obj) {
            return DocWriter.json().writeAsString(obj);
        }

        public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
            try {
                return DocReader.json().read(new InputStreamReader(jsonStream, charset));
            }
            catch (DocumentParseException | IOException e) {
                throw new InvalidJsonException((Throwable)e);
            }
        }

        public Object parse(String json) throws InvalidJsonException {
            try {
                return DocReader.json().read(json);
            }
            catch (DocumentParseException e) {
                throw new InvalidJsonException((Throwable)e);
            }
        }

        public Object createMap() {
            return new LinkedHashMap();
        }

        public Object createArray() {
            return new ArrayList();
        }
    };
    public static final MappingProvider MAPPING_PROVIDER = new MappingProvider(){

        public <T> T map(Object source, Class<T> targetType, Configuration configuration) {
            if (source == null) {
                return null;
            }
            if (targetType.isAssignableFrom(source.getClass())) {
                return targetType.cast(source);
            }
            if (targetType.equals(String.class)) {
                return targetType.cast(source.toString());
            }
            if (source instanceof Number) {
                Number number = (Number)source;
                if (Long.class.equals(targetType)) {
                    return targetType.cast(number.longValue());
                }
                if (Integer.class.equals(targetType)) {
                    return targetType.cast(number.intValue());
                }
                if (Short.class.equals(targetType)) {
                    return targetType.cast(number.shortValue());
                }
                if (Byte.class.equals(targetType)) {
                    return targetType.cast(number.byteValue());
                }
                if (Float.class.equals(targetType)) {
                    return targetType.cast(Float.valueOf(number.floatValue()));
                }
                if (Double.class.equals(targetType)) {
                    return targetType.cast(number.doubleValue());
                }
                if (BigDecimal.class.equals(targetType)) {
                    if (number instanceof BigInteger) {
                        return targetType.cast(new BigDecimal((BigInteger)number));
                    }
                    return targetType.cast(new BigDecimal(number.toString()));
                }
                if (BigInteger.class.equals(targetType)) {
                    return targetType.cast(new BigInteger(number.toString()));
                }
            } else {
                String string = source.toString();
                try {
                    if (String.class.equals(targetType)) {
                        return targetType.cast(string);
                    }
                    if (Long.class.equals(targetType)) {
                        return targetType.cast(Long.valueOf(string));
                    }
                    if (Integer.class.equals(targetType)) {
                        return targetType.cast(Integer.valueOf(string));
                    }
                    if (Short.class.equals(targetType)) {
                        return targetType.cast(Short.valueOf(string));
                    }
                    if (Byte.class.equals(targetType)) {
                        return targetType.cast(Byte.valueOf(string));
                    }
                    if (Float.class.equals(targetType)) {
                        return targetType.cast(Float.valueOf(string));
                    }
                    if (Double.class.equals(targetType)) {
                        return targetType.cast(Double.valueOf(string));
                    }
                    if (BigDecimal.class.equals(targetType)) {
                        return targetType.cast(new BigDecimal(string));
                    }
                    if (BigInteger.class.equals(targetType)) {
                        return targetType.cast(new BigInteger(string));
                    }
                    if (Boolean.class.equals(targetType)) {
                        return targetType.cast(Boolean.valueOf(string));
                    }
                    if (Character.class.equals(targetType)) {
                        if (string.length() == 0) {
                            return null;
                        }
                        return targetType.cast(Character.valueOf(string.charAt(0)));
                    }
                }
                catch (NumberFormatException e) {
                    throw new MappingException((Throwable)e);
                }
            }
            throw new MappingException("Unsupported mapping from " + source.getClass() + " to " + targetType);
        }

        public <T> T map(Object source, TypeRef<T> targetType, Configuration configuration) {
            throw new UnsupportedOperationException("map(TypeRef) is not supported");
        }
    };
    private static final Configuration DEFAULT_CONFIGURATION = BasicJsonPathDefaultConfiguration.builder().build();
    private static final Configuration LIST_DEFAULT_CONFIGURATION = BasicJsonPathDefaultConfiguration.builder().options(new Option[]{Option.ALWAYS_RETURN_LIST}).build();

    public static Configuration defaultConfiguration() {
        return DEFAULT_CONFIGURATION;
    }

    public static Configuration listDefaultConfiguration() {
        return LIST_DEFAULT_CONFIGURATION;
    }

    public static Configuration.ConfigurationBuilder builder() {
        return Configuration.builder().jsonProvider(JSON_PROVIDER).mappingProvider(MAPPING_PROVIDER);
    }

    public JsonProvider jsonProvider() {
        return JSON_PROVIDER;
    }

    public Set<Option> options() {
        return EnumSet.noneOf(Option.class);
    }

    public MappingProvider mappingProvider() {
        return MAPPING_PROVIDER;
    }
}

