/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.documents;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocWriter;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.Metadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public interface Document<T> {
    public Object toBasicObject();

    default public String toString(Format format) {
        return DocWriter.format(format).writeAsString(this.toBasicObject());
    }

    default public byte[] toBytes(Format format) {
        return DocWriter.format(format).writeAsBytes(this.toBasicObject());
    }

    default public String toJsonString() {
        return this.toString(Format.JSON);
    }

    default public String toPrettyJsonString() {
        return DocWriter.format(Format.JSON).pretty().writeAsString(this.toBasicObject());
    }

    default public String toYamlString() {
        return this.toString(Format.YAML);
    }

    default public byte[] toSmile() {
        return this.toBytes(Format.SMILE);
    }

    default public DocNode toDocNode() {
        Object basicObject = this.toBasicObject();
        if (basicObject != null) {
            return DocNode.wrap(basicObject);
        }
        return null;
    }

    default public Object toDeepBasicObject() {
        return Document.toDeepBasicObject(this.toBasicObject());
    }

    default public Metadata<T> meta() {
        return null;
    }

    public static <T> Document<T> assertedType(Object object, Class<T> type) {
        return DocNode.wrap(object);
    }

    public static Object toDeepBasicObject(Object object) {
        if (object instanceof Document) {
            return ((Document)object).toDeepBasicObject();
        }
        if (object instanceof Collection) {
            ArrayList<Object> result = new ArrayList<Object>(((Collection)object).size());
            for (Object subObject : (Collection)object) {
                result.add(Document.toDeepBasicObject(subObject));
            }
            return result;
        }
        if (object instanceof Map) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(((Map)object).size());
            for (Map.Entry entry : ((Map)object).entrySet()) {
                result.put(String.valueOf(entry.getKey()), Document.toDeepBasicObject(entry.getValue()));
            }
            return result;
        }
        return object;
    }
}

