/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.codova.validation.errors;

import com.floragunn.codova.validation.errors.ValidationError;
import java.util.LinkedHashMap;
import java.util.Map;

public class InvalidAttributeValue
extends ValidationError {
    private final Object value;

    public InvalidAttributeValue(String attribute, Object value, Object expected, Object jsonNode) {
        super(attribute, "Invalid value");
        this.expected(expected);
        this.value = value;
        this.docNode(jsonNode);
    }

    public InvalidAttributeValue(String attribute, Object value, Object expected) {
        this(attribute, value, expected, null);
    }

    @Override
    public Map<String, Object> toBasicObject() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("error", this.getMessage());
        result.put("value", this.value);
        if (this.getExpected() != null) {
            result.put("expected", this.getExpectedAsString());
        }
        return result;
    }

    @Override
    public String toString() {
        return this.getMessage() + " " + (this.getExpected() != null ? "; expected: " + this.getExpectedAsString() : "") + "; value: " + this.value + "; attribute: " + this.getAttribute();
    }

    @Override
    public String toValidationErrorsOverviewString() {
        StringBuilder result = new StringBuilder(this.getMessage());
        if (this.getExpected() != null) {
            result.append("; expected: ").append(this.getExpectedAsString());
        }
        result.append("; got: ").append(this.value);
        return result.toString();
    }

    @Override
    public InvalidAttributeValue expected(Object expected) {
        super.expected(expected);
        return this;
    }

    @Override
    protected InvalidAttributeValue clone() {
        return (InvalidAttributeValue)new InvalidAttributeValue(this.getAttribute(), this.value, this.getExpected()).cause(this.getCause()).docNode(this.getDocNode()).message(this.getMessage());
    }
}

