/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections.views;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.fluent.collections.UnmodifiableCollection;
import com.floragunn.fluent.collections.UnmodifiableMap;
import com.floragunn.fluent.collections.UnmodifiableSet;
import com.floragunn.fluent.collections.views.CollectionView;
import com.floragunn.fluent.collections.views.MapView;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

class MapViewImpl {
    MapViewImpl() {
    }

    static <K, V, VT> MapView<K, VT> mapValues(Map<K, V> map, Function<V, VT> valueMappingFunction) {
        return new ValueRewritingMapView<K, V, VT>(map, valueMappingFunction);
    }

    static UnmodifiableMap<String, Object> stringKeys(Map<?, ?> map) {
        if (map instanceof ImmutableMap) {
            ImmutableMap<String, Object> result = ((ImmutableMap)map).ensureKeyType(String.class, String::valueOf);
            return result;
        }
        boolean allKeysAreStrings = map.keySet().stream().allMatch(o -> o instanceof String || o == null);
        if (map instanceof UnmodifiableMap && allKeysAreStrings) {
            UnmodifiableMap result = (UnmodifiableMap)map;
            return result;
        }
        OrderedImmutableMap.Builder result = new OrderedImmutableMap.Builder(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            result.put(entry.getKey() != null ? entry.getKey().toString() : null, entry.getValue());
        }
        return result.build();
    }

    static Map<String, Object> stringKeysUnsafe(Map<?, ?> map) {
        if (map instanceof ImmutableMap) {
            ImmutableMap<String, Object> result = ((ImmutableMap)map).ensureKeyType(String.class, String::valueOf);
            return result;
        }
        boolean allKeysAreStrings = map.keySet().stream().allMatch(o -> o instanceof String || o == null);
        if (allKeysAreStrings) {
            Map<String, Object> result = map;
            return result;
        }
        OrderedImmutableMap.Builder<String, Object> result = new OrderedImmutableMap.Builder<String, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.put(entry.getKey() != null ? entry.getKey().toString() : null, entry.getValue());
        }
        return result.build();
    }

    static class ValueRewritingMapView<K, V1, V2>
    extends AbstractMap<K, V2>
    implements MapView<K, V2> {
        private final Map<K, V1> sourceMap;
        private final Function<V1, V2> valueMappingFunction;

        public ValueRewritingMapView(Map<K, V1> sourceMap, Function<V1, V2> valueMappingFunction) {
            this.sourceMap = sourceMap;
            this.valueMappingFunction = valueMappingFunction;
        }

        @Override
        public int size() {
            return this.sourceMap.size();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.sourceMap.containsKey(key);
        }

        @Override
        public V2 get(Object key) {
            if (this.sourceMap.containsKey(key)) {
                return this.valueMappingFunction.apply(this.sourceMap.get(key));
            }
            return null;
        }

        @Override
        public UnmodifiableSet<K> keySet() {
            return UnmodifiableSet.of(this.sourceMap.keySet());
        }

        @Override
        public UnmodifiableSet<Map.Entry<K, V2>> entrySet() {
            final Set<Map.Entry<K, V1>> delegateEntrySet = this.sourceMap.entrySet();
            return UnmodifiableSet.of(new AbstractSet<Map.Entry<K, V2>>(){

                @Override
                public Iterator<Map.Entry<K, V2>> iterator() {
                    final Iterator delegateIterator = delegateEntrySet.iterator();
                    return new Iterator<Map.Entry<K, V2>>(){

                        @Override
                        public boolean hasNext() {
                            return delegateIterator.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V2> next() {
                            Map.Entry sourceEntry = (Map.Entry)delegateIterator.next();
                            return new AbstractMap.SimpleEntry(sourceEntry.getKey(), valueMappingFunction.apply(sourceEntry.getValue()));
                        }
                    };
                }

                @Override
                public int size() {
                    return delegateEntrySet.size();
                }
            });
        }

        @Override
        public UnmodifiableCollection<V2> values() {
            return CollectionView.map(this.sourceMap.values(), this.valueMappingFunction);
        }
    }
}

