/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.action.initialize_key;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class InitializeKeyRequest
extends MasterNodeRequest<InitializeKeyRequest> {
    private byte[] base64EncodedPrivateRsaKey;

    public InitializeKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.base64EncodedPrivateRsaKey = in.readByteArray();
    }

    public InitializeKeyRequest(byte[] base64EncodedPrivateRsaKey) {
        super(TimeValue.THIRTY_SECONDS);
        this.setKey(base64EncodedPrivateRsaKey);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByteArray(this.base64EncodedPrivateRsaKey);
    }

    public byte[] getKey() {
        return this.base64EncodedPrivateRsaKey;
    }

    public void setKey(byte[] base64EncodedPrivateRsaKey) {
        this.base64EncodedPrivateRsaKey = base64EncodedPrivateRsaKey;
    }

    public ActionRequestValidationException validate() {
        if (this.base64EncodedPrivateRsaKey == null) {
            return new ActionRequestValidationException();
        }
        return null;
    }
}

