/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.plugin.validator;

import com.floragunn.encryption.at.rest.plugin.EncryptionAtRestPluginSettings;
import com.floragunn.encryption.at.rest.plugin.KeyStore;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.MappedActionFilter;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;

public class CreateIndexValidatorActionFilter
implements MappedActionFilter {
    private final KeyStore keyStore;

    public CreateIndexValidatorActionFilter(KeyStore keyStore) {
        this.keyStore = Objects.requireNonNull(keyStore, "KeyStore must not be null");
    }

    public String actionName() {
        return TransportCreateIndexAction.TYPE.name();
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        CreateIndexRequest createIndexRequest = (CreateIndexRequest)request;
        if (EncryptionAtRestPluginSettings.INDEX_ENCRYPTION_ENABLED.getFrom(createIndexRequest.settings()).booleanValue() && Objects.isNull(this.keyStore.getClusterKeK())) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Cluster is not initialized. No cluster key set.", RestStatus.SERVICE_UNAVAILABLE, (Throwable)new IllegalArgumentException("Cluster not initialized."), new Object[0]));
            return;
        }
        chain.proceed(task, action, request, listener);
    }
}

