/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.rest;

import com.floragunn.encryption.at.rest.action.initialize_key.InitializeKeyAction;
import com.floragunn.encryption.at.rest.action.initialize_key.InitializeKeyRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentType;

public class InitializeKeyApiAction
extends BaseRestHandler {
    private final ClusterService clusterService;
    private final ThreadContext threadContext;

    public InitializeKeyApiAction(ClusterService clusterService, ThreadContext threadContext) {
        this.clusterService = clusterService;
        this.threadContext = threadContext;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_encryption_at_rest/api/_initialize_key"));
    }

    public String getName() {
        return "Initialize Key Action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ReleasableBytesReference content = request.requiredContent();
        Map map = (Map)XContentHelper.convertToMap((BytesReference)content, (boolean)false, (XContentType)request.getXContentType()).v2();
        return channel -> client.execute((ActionType)InitializeKeyAction.INSTANCE, (ActionRequest)new InitializeKeyRequest(((String)map.get("key")).getBytes(StandardCharsets.UTF_8)), (ActionListener)new RestToXContentListener(channel));
    }
}

