/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import java.util.concurrent.atomic.AtomicLongArray;

final class AtomicBitSet {
    private final AtomicLongArray bits;
    private final long size;

    AtomicBitSet(long size) {
        this.size = size;
        this.bits = new AtomicLongArray((int)((size + 63L) / 64L));
    }

    boolean getAndSet(long index) {
        long oldValue;
        if (index < 0L || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int wordIndex = (int)(index >>> 6);
        long bitMask = 1L << (int)(index & 0x3FL);
        do {
            if (((oldValue = this.bits.get(wordIndex)) & bitMask) == 0L) continue;
            return true;
        } while (!this.bits.compareAndSet(wordIndex, oldValue, oldValue | bitMask));
        return false;
    }

    boolean get(long index) {
        if (index < 0L || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int wordIndex = (int)(index >>> 6);
        long bitMask = 1L << (int)(index & 0x3FL);
        long currentValue = this.bits.get(wordIndex);
        return (currentValue & bitMask) != 0L;
    }

    void clear(long index) {
        long oldValue;
        if (index < 0L || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int wordIndex = (int)(index >>> 6);
        long bitMask = 1L << (int)(index & 0x3FL);
        while (!this.bits.compareAndSet(wordIndex, oldValue = this.bits.get(wordIndex), oldValue & (bitMask ^ 0xFFFFFFFFFFFFFFFFL))) {
        }
    }
}

