/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import com.floragunn.encryption.at.rest.lucene.encryption.DirectoryKey;
import com.floragunn.encryption.at.rest.lucene.encryption.Footer;
import com.floragunn.encryption.at.rest.lucene.encryption.Metrics;
import com.floragunn.encryption.at.rest.lucene.encryption.TagStrategy;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;

final class DecryptingBufferedIndexInput
extends BufferedIndexInput {
    private static final int READ_CHUNK_SIZE = 16384;
    private static final ByteBuffer EMPTY_BYTEBUFFER = ByteBuffer.allocate(0);
    protected final FileChannel channel;
    boolean isClone = false;
    protected final long off;
    protected final long end;
    private ByteBuffer decryptionBuffer;
    private long currentChunk = -1L;
    private Footer footer;
    private Path path;

    public DecryptingBufferedIndexInput(String resourceDesc, FileChannel fc, Path path, IOContext context, DirectoryKey directoryKey) throws IOException {
        super(resourceDesc, context);
        this.channel = fc;
        this.off = 0L;
        long size = fc.size();
        if (size > (long)Footer.MIN_SIZE) {
            ByteBuffer footerSizeBuffer = ByteBuffer.allocate(4);
            fc.position(size - (long)Footer.LENGTH_INFO_OFFSET);
            fc.read(footerSizeBuffer);
            footerSizeBuffer.flip();
            int footerSize = footerSizeBuffer.getInt();
            footerSizeBuffer = null;
            fc.position(size - (long)footerSize);
            ByteBuffer footerBuffer = ByteBuffer.allocate(footerSize);
            fc.read(footerBuffer);
            footerBuffer.flip();
            this.footer = Footer.readFrom(footerBuffer, directoryKey);
            footerBuffer = null;
            this.decryptionBuffer = EMPTY_BYTEBUFFER;
            this.end = this.footer.getPlainTextFileSize();
        } else {
            this.end = 0L;
            this.footer = null;
        }
        this.path = path;
        Metrics.recordInputOpen("nio", false, false, path, this.length(), context);
    }

    public DecryptingBufferedIndexInput(String resourceDesc, FileChannel fc, long off, long length, int bufferSize, Footer footer, Path path) {
        super(resourceDesc, bufferSize);
        this.channel = fc;
        this.off = off;
        this.decryptionBuffer = EMPTY_BYTEBUFFER;
        this.end = off + length;
        this.isClone = true;
        this.currentChunk = -1L;
        this.footer = footer;
        this.path = path;
        Metrics.recordInputOpen("nio", true, true, path, this.length(), null);
    }

    public void close() throws IOException {
        Metrics.recordInputClose("nio", this.isClone, this.path, this.length());
        if (!this.isClone) {
            this.channel.close();
        }
        this.decryptionBuffer = null;
    }

    public DecryptingBufferedIndexInput clone() {
        DecryptingBufferedIndexInput clone = (DecryptingBufferedIndexInput)super.clone();
        clone.isClone = true;
        clone.decryptionBuffer = EMPTY_BYTEBUFFER;
        clone.footer = this.footer;
        clone.currentChunk = -1L;
        clone.path = this.path;
        Metrics.recordInputOpen("nio", true, false, this.path, this.length(), null);
        return clone;
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        if ((length | offset) < 0L || length > this.length() - offset) {
            throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length() + ": " + String.valueOf((Object)this));
        }
        return new DecryptingBufferedIndexInput(this.getFullSliceDescription(sliceDescription), this.channel, this.off + offset, length, this.getBufferSize(), this.footer, this.path);
    }

    public final long length() {
        return this.end - this.off;
    }

    protected void readInternal(ByteBuffer b) throws IOException {
        long pos = this.getFilePointer() + this.off;
        if (pos + (long)b.remaining() > this.end) {
            throw new EOFException("read past EOF: " + String.valueOf((Object)this));
        }
        long chunkToStartReading = pos / (long)this.footer.getMode().getChunkSize();
        int totalBytesNeeded = b.remaining();
        int bytesWritten = 0;
        if (this.decryptionBuffer == EMPTY_BYTEBUFFER) {
            this.decryptionBuffer = ByteBuffer.allocate(this.footer.getMode().getChunkTagSize());
        }
        while (bytesWritten < totalBytesNeeded) {
            this.decryptChunk(chunkToStartReading);
            int adjustedPosInBuffer = (int)(pos + (long)bytesWritten - (long)this.footer.getMode().getChunkSize() * chunkToStartReading);
            this.decryptionBuffer.position(adjustedPosInBuffer);
            int bytesAvailableInChunk = this.decryptionBuffer.remaining();
            int bytesToReadFromChunk = Math.min(bytesAvailableInChunk, totalBytesNeeded - bytesWritten);
            int originalLimit = this.decryptionBuffer.limit();
            this.decryptionBuffer.limit(this.decryptionBuffer.position() + bytesToReadFromChunk);
            b.put(this.decryptionBuffer);
            this.decryptionBuffer.limit(originalLimit);
            bytesWritten += bytesToReadFromChunk;
            ++chunkToStartReading;
        }
    }

    private void decryptChunk(long chunk) throws IOException {
        if (chunk < 0L || chunk >= this.footer.getChunkCount()) {
            throw new IllegalArgumentException("chunk out of bounds: chunk=" + chunk + ",chunkCount=" + this.footer.getChunkCount() + ": " + String.valueOf((Object)this));
        }
        if (chunk == this.currentChunk) {
            this.decryptionBuffer.position(0);
            return;
        }
        this.decryptionBuffer.clear();
        if (this.footer.isLastChunk(chunk)) {
            this.decryptionBuffer.limit(this.footer.getLastChunkSize());
        } else {
            this.decryptionBuffer.limit(this.footer.getMode().getChunkSize());
        }
        Optional<Long> tagPos = this.footer.getTagOffsetForChunk(chunk);
        long cipherTextPos = chunk * (long)(this.footer.getMode().getTagStrategy() == TagStrategy.APPEND_TO_END ? this.footer.getMode().getChunkSize() : this.footer.getMode().getChunkTagSize());
        try {
            if (this.footer.getMode().getTagStrategy() == TagStrategy.APPEND_TO_CHUNK) {
                this.decryptionBuffer.limit(this.decryptionBuffer.limit() + this.footer.getMode().getTagLength());
            }
            if (DecryptingBufferedIndexInput.read(this.channel, cipherTextPos, this.decryptionBuffer) <= 0) {
                throw new EOFException("read past EOF: " + String.valueOf((Object)this));
            }
            if (tagPos.isPresent()) {
                this.decryptionBuffer.limit(this.decryptionBuffer.limit() + this.footer.getMode().getTagLength());
                if (DecryptingBufferedIndexInput.read(this.channel, tagPos.get(), this.decryptionBuffer) <= 0) {
                    throw new EOFException("read past EOF: " + String.valueOf((Object)this));
                }
            }
            this.decryptionBuffer.flip();
            ByteBuffer dup = this.decryptionBuffer.duplicate().limit(this.decryptionBuffer.limit() - this.footer.getMode().getTagLength());
            this.footer.getMode().decrypt(this.footer.getFileKey(), this.decryptionBuffer, dup, chunk);
            this.decryptionBuffer.position(0);
            this.decryptionBuffer.limit(dup.limit());
            this.currentChunk = chunk;
        }
        catch (Exception ioe) {
            throw new IOException(ioe.getMessage() + ": " + String.valueOf((Object)this), ioe);
        }
    }

    protected void seekInternal(long pos) throws IOException {
        if (pos > this.length()) {
            throw new EOFException("read past EOF: pos=" + pos + " vs length=" + this.length() + ": " + String.valueOf((Object)this));
        }
        Metrics.recordSeek("nio", this.path, this.length(), pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int read(FileChannel fileChannel, long pos, ByteBuffer buffer) throws IOException {
        if (fileChannel == null) {
            throw new IllegalArgumentException("FileChannel cannot be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("ByteBuffer cannot be null");
        }
        if (pos < 0L) {
            throw new IllegalArgumentException("Position cannot be negative");
        }
        long fileSize = fileChannel.size();
        if (pos >= fileSize || buffer.remaining() == 0) {
            return 0;
        }
        long maxBytesToRead = Math.min((long)buffer.remaining(), fileSize - pos);
        long currentPosition = pos;
        long bytesRemaining = maxBytesToRead;
        int originalLimit = buffer.limit();
        int bytesTransferred = 0;
        try {
            while (bytesRemaining > 0L) {
                int chunkSize = (int)Math.min(16384L, bytesRemaining);
                buffer.limit(buffer.position() + chunkSize);
                int bytesRead = fileChannel.read(buffer, currentPosition);
                if (bytesRead <= 0) {
                } else {
                    currentPosition += (long)bytesRead;
                    bytesRemaining -= (long)bytesRead;
                    bytesTransferred += bytesRead;
                    if (bytesRead >= chunkSize) continue;
                }
                break;
            }
        }
        finally {
            buffer.limit(originalLimit);
        }
        return bytesTransferred;
    }
}

