/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.lucene.encryption;

import com.floragunn.encryption.at.rest.lucene.encryption.NativeAccess;
import java.io.IOException;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.Locale;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.lucene.store.ReadAdvice;

final class PosixNativeAccess
extends NativeAccess {
    private static final Logger LOG = Logger.getLogger(PosixNativeAccess.class.getName());
    public static final int POSIX_MADV_NORMAL = 0;
    public static final int POSIX_MADV_RANDOM = 1;
    public static final int POSIX_MADV_SEQUENTIAL = 2;
    public static final int POSIX_MADV_WILLNEED = 3;
    public static final int POSIX_MADV_DONTNEED = 4;
    private static final MethodHandle MH$posix_madvise;
    private static final Optional<NativeAccess> INSTANCE;

    private PosixNativeAccess() {
    }

    static Optional<NativeAccess> getInstance() {
        return INSTANCE;
    }

    private static MethodHandle lookupMadvise() {
        Linker linker = Linker.nativeLinker();
        SymbolLookup stdlib = linker.defaultLookup();
        return PosixNativeAccess.findFunction(linker, stdlib, "posix_madvise", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT));
    }

    private static MethodHandle findFunction(Linker linker, SymbolLookup lookup, String name, FunctionDescriptor desc) {
        MemorySegment symbol = lookup.find(name).orElseThrow(() -> new UnsupportedOperationException("Platform has no symbol for '" + name + "' in libc."));
        return linker.downcallHandle(symbol, desc, new Linker.Option[0]);
    }

    @Override
    public void madvise(MemorySegment segment, ReadAdvice readAdvice) throws IOException {
        int ret;
        if (segment.byteSize() == 0L) {
            return;
        }
        Integer advice = this.mapReadAdvice(readAdvice);
        if (advice == null) {
            return;
        }
        try {
            ret = MH$posix_madvise.invokeExact(segment, segment.byteSize(), advice);
        }
        catch (Throwable th) {
            throw new AssertionError((Object)th);
        }
        if (ret != 0) {
            throw new IOException(String.format(Locale.ENGLISH, "Call to posix_madvise with address=0x%08X and byteSize=%d failed with return code %d.", segment.address(), segment.byteSize(), ret));
        }
    }

    private Integer mapReadAdvice(ReadAdvice readAdvice) {
        return switch (readAdvice) {
            default -> throw new MatchException(null, null);
            case ReadAdvice.NORMAL -> null;
            case ReadAdvice.RANDOM -> 1;
            case ReadAdvice.SEQUENTIAL -> 2;
            case ReadAdvice.RANDOM_PRELOAD -> null;
        };
    }

    static {
        MethodHandle adviseHandle = null;
        PosixNativeAccess instance = null;
        try {
            adviseHandle = PosixNativeAccess.lookupMadvise();
            instance = new PosixNativeAccess();
        }
        catch (UnsupportedOperationException uoe) {
            LOG.warning(uoe.getMessage());
        }
        catch (IllegalCallerException ice) {
            LOG.warning(String.format(Locale.ENGLISH, "Lucene has no access to native functions. To enable access to native functions, pass the following on command line: --enable-native-access=%s", Optional.ofNullable(PosixNativeAccess.class.getModule().getName()).orElse("ALL-UNNAMED")));
        }
        MH$posix_madvise = adviseHandle;
        INSTANCE = Optional.ofNullable(instance);
    }
}

