/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.repo;

import com.floragunn.encryption.at.rest.key_management.AESKey;
import com.floragunn.encryption.at.rest.key_management.WrappedAESKey;
import com.floragunn.encryption.at.rest.key_management.WrappedAESKeyContainer;
import com.floragunn.encryption.at.rest.plugin.KeyStore;
import com.floragunn.encryption.at.rest.repo.EncryptedBlobStore;
import com.floragunn.encryption.at.rest.repo.EncryptedRepositoryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.IllegalBlockSizeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.OperationPurpose;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryStats;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class EncryptedRepository
extends BlobStoreRepository {
    private static Logger logger = LogManager.getLogger(EncryptedRepository.class);
    private static final String REPOSITORY_KEY_FILE_NAME = "_encrypted_repository_key";
    public static final String REPOSITORY_TYPE = "encrypted";
    private final KeyStore keyStore;
    private volatile BlobStoreRepository delegateRepo;
    private final ByteSizeValue chunkSize;

    EncryptedRepository(ProjectId projectId, BigArrays bigArrays, BlobStoreRepository delegateRepo, RepositoryMetadata metadata, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, RecoverySettings recoverySettings, KeyStore keyStore, ByteSizeValue chunkSize) {
        super(projectId, metadata, namedXContentRegistry, clusterService, bigArrays, recoverySettings, BlobPath.EMPTY);
        this.delegateRepo = delegateRepo;
        this.keyStore = Objects.requireNonNull(keyStore, "KeyStore must not be null");
        this.chunkSize = Objects.requireNonNull(chunkSize, "ChunkSize must not be null");
    }

    protected BlobStore createBlobStore() throws Exception {
        logger.trace("Creating EncryptedBlobStore for delegate repo {}", (Object)this.delegateRepo);
        if (this.keyStore.getClusterKeK() == null) {
            throw new Exception("Cluster key must not be null here");
        }
        return new EncryptedBlobStore(this.delegateRepo.blobStore(), this.createOrRestoreRepositoryKey(), (Boolean)EncryptedRepositoryFactory.SUPPORT_UPLOAD_RETRY.get(this.metadata.settings()));
    }

    public BlobPath basePath() {
        return this.delegateRepo.basePath();
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    protected void doStart() {
        this.delegateRepo.start();
        super.doStart();
        logger.trace("starting for delegate repo {} and base path {} with metadata name {}, type {}, more {}", (Object)this.delegateRepo, (Object)this.basePath(), (Object)this.metadata.name(), (Object)this.metadata.type(), (Object)this.metadata.toString());
        logger.trace("delegated metadata name {}, type {}, more {}", (Object)this.delegateRepo.getMetadata().name(), (Object)this.delegateRepo.getMetadata().type(), (Object)this.delegateRepo.getMetadata().toString());
    }

    protected void doStop() {
        logger.trace("stopping repo {}", (Object)this.metadata.name());
        super.doStop();
        this.delegateRepo.stop();
    }

    protected void doClose() {
        logger.trace("closing repo {}", (Object)this.metadata.name());
        super.doClose();
        this.delegateRepo.close();
    }

    public RepositoryStats stats() {
        return this.delegateRepo.stats();
    }

    private AESKey createOrRestoreRepositoryKey() throws IOException, IllegalBlockSizeException, NoSuchAlgorithmException, InvalidKeyException {
        AESKey repositoryKey;
        BlobContainer blobContainer = this.delegateRepo.blobStore().blobContainer(this.basePath());
        if (blobContainer.blobExists(OperationPurpose.SNAPSHOT_METADATA, REPOSITORY_KEY_FILE_NAME)) {
            logger.debug("Restore repository key");
            try (InputStream in = blobContainer.readBlob(OperationPurpose.SNAPSHOT_METADATA, REPOSITORY_KEY_FILE_NAME);){
                repositoryKey = this.keyStore.getClusterKeK().unwrapAESKey(new WrappedAESKey(in.readAllBytes()));
            }
        } else {
            logger.debug("Create repository key");
            if (this.isReadOnly()) {
                throw new RepositoryException(REPOSITORY_TYPE, "Couldn't create repository key. The repository " + this.metadata.name() + " is in readonly mode", new Object[0]);
            }
            WrappedAESKeyContainer wrappedAESKeyContainer = this.keyStore.getClusterKeK().newRandomWrapped();
            BytesArray wrappedKeyBytes = new BytesArray(wrappedAESKeyContainer.wrappedAESKey().bytes());
            blobContainer.writeBlobAtomic(OperationPurpose.SNAPSHOT_METADATA, REPOSITORY_KEY_FILE_NAME, (BytesReference)wrappedKeyBytes, true);
            repositoryKey = wrappedAESKeyContainer.aesKey();
        }
        return repositoryKey;
    }
}

