/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.encryption.at.rest.action.initialize_key;

import com.floragunn.encryption.at.rest.action.initialize_key.InitializeKeyRequest;
import com.floragunn.encryption.at.rest.action.initialize_key.InitializeKeyResponse;
import com.floragunn.encryption.at.rest.action.update_key.UpdateKeyAction;
import com.floragunn.encryption.at.rest.action.update_key.UpdateKeyRequest;
import com.floragunn.encryption.at.rest.action.update_key.UpdateKeyResponse;
import com.floragunn.encryption.at.rest.key_management.AESKey;
import com.floragunn.encryption.at.rest.key_management.ClusterKeK;
import com.floragunn.encryption.at.rest.key_management.RSAEncryptedAndSignedAESKey;
import com.floragunn.encryption.at.rest.plugin.KeyStore;
import com.floragunn.encryption.at.rest.support.DataFilesUtil;
import com.floragunn.encryption.at.rest.support.KeyPairValidator;
import com.floragunn.encryption.at.rest.support.RSAUtil;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteResponse;
import org.elasticsearch.action.admin.cluster.reroute.TransportClusterRerouteAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportInitializeKeyAction
extends TransportMasterNodeAction<InitializeKeyRequest, InitializeKeyResponse> {
    private final Client client;
    private final Environment environment;
    private final KeyStore keyStore;
    protected Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    public static final ActionType<InitializeKeyResponse> TYPE = new ActionType("cluster:admin/searchguard_encryption_at_rest/initialize_key");

    @Inject
    public TransportInitializeKeyAction(KeyStore keyStore, Client client, Environment environment, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/searchguard_encryption_at_rest/initialize_key", transportService, clusterService, threadPool, actionFilters, InitializeKeyRequest::new, InitializeKeyResponse::new, (Executor)threadPool.executor("management"));
        this.keyStore = Objects.requireNonNull(keyStore, "KeyStore must not be null");
        this.client = client;
        this.environment = environment;
    }

    protected ClusterBlockException checkBlock(InitializeKeyRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(Task task2, InitializeKeyRequest request, ClusterState clusterState, final ActionListener<InitializeKeyResponse> listener) throws Exception {
        try {
            PublicKey publicClusterKey = this.keyStore.getPublicClusterKey();
            if (publicClusterKey == null) {
                this.logger.error("No public key found in the cluster");
                listener.onFailure(new Exception("No public key found in the cluster"));
                return;
            }
            PrivateKey privateClusterKey = null;
            try {
                privateClusterKey = RSAUtil.parsePrivateKey(request.getKey());
                if (privateClusterKey == null) {
                    this.logger.error("Can not parse private key");
                    listener.onFailure(new Exception("Can not parse private key"));
                    return;
                }
            }
            catch (Exception e) {
                this.logger.error("Can not parse private key: {}", (Object)e, (Object)e);
                listener.onFailure(new Exception("Can not parse private key", e));
                return;
            }
            boolean isSameKeyPair = KeyPairValidator.areKeyPairMatch(privateClusterKey, publicClusterKey);
            if (!isSameKeyPair) {
                this.logger.error("Wrong key for this cluster");
                listener.onFailure(new Exception("Wrong key for this cluster"));
                return;
            }
            ClusterKeK clusterKeK = this.generateOrLoadClusterKek(new KeyPair(publicClusterKey, privateClusterKey), "_encrypted_cluster_key");
            this.client.execute((ActionType)UpdateKeyAction.INSTANCE, (ActionRequest)new UpdateKeyRequest(clusterKeK), (ActionListener)new ActionListener<UpdateKeyResponse>(){
                final /* synthetic */ TransportInitializeKeyAction this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(UpdateKeyResponse updateKeyResponse) {
                    ClusterRerouteResponse response = (ClusterRerouteResponse)this.this$0.client.execute(TransportClusterRerouteAction.TYPE, (ActionRequest)new ClusterRerouteRequest(TimeValue.THIRTY_SECONDS, TimeValue.THIRTY_SECONDS).setRetryFailed(true)).actionGet();
                    listener.onResponse((Object)new InitializeKeyResponse(updateKeyResponse));
                }

                public void onFailure(Exception e) {
                    this.this$0.logger.error("Update keys encryption key failed: {}", (Object)e, (Object)e);
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            this.logger.error("Initialization exception: {}", (Object)e, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private ClusterKeK generateOrLoadClusterKek(KeyPair keyPair, String filename) throws Exception {
        Path storeDir = DataFilesUtil.findLocation(this.environment, filename);
        Path storedFile = storeDir.resolve(filename);
        if (Files.exists(storedFile, new LinkOption[0])) {
            this.logger.trace("Read cluster key (on master) from {} ({})", (Object)storedFile, (Object)this.hashOfFile(storedFile));
            RSAEncryptedAndSignedAESKey rsaEncryptedAndSignedAESKey = new RSAEncryptedAndSignedAESKey(Files.readAllBytes(storedFile));
            return new ClusterKeK(RSAUtil.decryptKey(rsaEncryptedAndSignedAESKey, keyPair), rsaEncryptedAndSignedAESKey);
        }
        AESKey randomKey = AESKey.random();
        RSAEncryptedAndSignedAESKey rsaEncryptedAndSignedAESKey = RSAUtil.encryptKey(randomKey, keyPair);
        Files.write(storedFile, rsaEncryptedAndSignedAESKey.bytes(), StandardOpenOption.WRITE, StandardOpenOption.SYNC, StandardOpenOption.DSYNC, StandardOpenOption.CREATE_NEW);
        this.logger.trace("Store new cluster key (on master) under {} ({})", (Object)storedFile, (Object)this.hashOfFile(storedFile));
        return new ClusterKeK(randomKey, rsaEncryptedAndSignedAESKey);
    }

    private String hashOfFile(Path file) throws IOException {
        return Hashing.sha256().hashBytes(Files.readAllBytes(file)).toString();
    }
}

